/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISecureClientParameters.java,v 1.4 2005/10/03 22:03:03 gnagarajan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.execution.security;

import java.security.Provider;

/**
 * Secure Client Parameters for secure Agent Controller communication 
 * <B>This interface is not implemented in TPTP 4.1</B>
 */
public interface ISecureClientParameters {


	/**
	 * Get the Security Provider
	 */
	public Provider getSecurityProvider();

	/**
	 * Get the Key Store File Name
	 */
	public String getKeystoreFileName();

	/**
	 * Get Key Store File Password
	 */
	public String getKeystoreFilepassword();

	/**
	 * Get Security Key Store Manager
	 */
	public IKeystoreManager getKeystoreManager();

	/**
	 * Get enabled Cipher Suites
	 */
	public String[] getEnabledCipherSuites();

	/**
	 * Get enabled Protocols
	 */
	public String[] getEnabledProtocols();

	/**
	 * Check if Server requires authentication
	 */
	public boolean getRequiresServerAuthentication();

	/**
	 * Disable Server authentication
	 */
	public void disableServerAuthentication();

	/**
	 * Enable Server authentication 
	 */
	public void enableServerAuthentication();

}