/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: SecureConnectionInfo.java,v 1.5 2005/10/03 23:43:44 gnagarajan Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.security;

import java.security.*;

import org.eclipse.tptp.platform.execution.client.core.ConnectionInfo;

/**
 * @author vnaikawa
 *<B>This interface is not implemented in TPTP 4.1</B>
 * 
 */
public class SecureConnectionInfo extends ConnectionInfo {

	/**
	 * Security Manager
	 */
	private ISecureClientParameters _securityManager;
	
	/**
	 * Security Principal
	 */
	private Principal _principal;
	
	/**
	 * 
	 */
	public SecureConnectionInfo() {
		super();
	}
	
	
	/**
	 * Get Security Client Paramaters
	 * @return ISecureClientParameters
	 */
	public ISecureClientParameters getSecureClientParameters()
	{
		return _securityManager;
	}
	
	/**
	 * Set Security Client Parameters
	 * @param securityManager
	 */
	public void setSecureClientParameters(ISecureClientParameters securityManager)
	{
		_securityManager = securityManager;
	}
	
	/**
	 * Get the Principal
	 * @return Principal
	 */
	public Principal getPrincipal()
	{
		return _principal;
	}
	
	/**
	 * Set the Principal
	 * @param principal
	 */
	public void setPrincipal(Principal principal)
	{
		_principal = principal;
	}
	
}
