/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: User.java,v 1.7 2007/03/22 20:39:02 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.execution.security;

import org.eclipse.tptp.platform.execution.client.core.*;

import java.io.IOException;
import java.security.Principal;


/**
 * @author rduggan
 *<B>This interface is not implemented in TPTP 4.1</B>
 */
public class User implements Principal {

	private String _name;
	private String _password;
	private Principal _app;
	private String _alias;
	private boolean _isPasswordEncrypted;

	public static final boolean  ENABLE_PASSWORD_ENCRYPTION=false;


	public User(Principal app, String name, String password) {
		_app=app;
		_name=name;

		setPassword(password);


	}

	/**
	 * @see java.security.Principal#getName()
	 */
	public String getName() {
		return _name;
	}
	
	
	/**
	 * @see java.security.Principal#getName()
	 */
	public String getPassword() {
		return _password;
	}

	public void setPassword(String password) {
		/* Try and store the passowrd in memory encrypted. If we fail
		 * to encrypt the password we will store it as is.
		 */
		try {
			if(ENABLE_PASSWORD_ENCRYPTION) {
				_isPasswordEncrypted=true;
			}
			else {
				throw new RuntimeException();
			}
		}
		catch(Exception e) {
			_password=password;
			_isPasswordEncrypted=false;
		}

	}

	public Principal getApplication() {
		return _app;
	}






	public void login(INode node) throws IOException
	{


	}

}
