/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: ICommandElement.java,v 1.2 2005/10/03 22:22:14 gnagarajan Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util;

import org.eclipse.tptp.platform.execution.util.*; 
/**
 * ICommandElement is a generic interface for commands. 
 * A command is the mechanism of message passing between the client, agent controller and the agents. 
 * TPTP 4.0 uses new command protocol as described in overview.
 * See ICommandFragment to build and process additional commands using the XML protocol as required by TPTP 4.0.  
 * @since tptp 4.0 
 * @provisional
 */

public interface ICommandElement {


/**
* Get the Command Size.
* @return int
*/
public int getSize();

/**
* Get the Command Tag.
* @return int
*/
public long getTag();

/**
 * Get the Command Context ID
 */
public long getContext();

/**
 * Set the Command Context ID
 */
public void setContext(long contextID);

/**
 * Get the Source ID
 */
public long getSource();

/**
 * Set the Source ID
 */
public void setSource(long srcID);

/**
 * Get the Interface ID
 */
public String getInterfaceID();

/**
 * Set the Interface ID
 */
public void setInterfaceID(String interfaceID);


/**
 * Build the XML Command String using the parameters passed
 */
public String buildCommand(String srcID, String destID, String interfaceID, String cmdName, String ctxt, String processID, String agentID, String agentName);

/**
* Read the command from the input buffer.
* @return int
* @param buffer byte[]
* @param offset int
*/
public int readFromBuffer(byte[] buffer, int offset);

/**
* Write the XML Command to the input buffer.
* @return int
* @param buffer byte[]
* @param offset int
*/
public int writeToBuffer(byte[] buffer, int offset);

}
