/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: ICommandFragment.java,v 1.3 2005/10/27 22:30:39 gnagarajan Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util;

import java.util.*;
/**
 * ICommandFragment is a generic interface for command processing. 
 * A command is the mechanism of message passing between the client, agent controller and the agents.
 * @since tptp 4.0 
 * @provisional
 */
public interface ICommandFragment extends ICommandElement
{
	/**
	 * Set the XML Command String
	 */
	public void setCommand(String command);

	/**
	 * Get the Command Data
	 */
	public String getCommandData();

	/**
	 * Read Command Fragment from the input buffer
	 */
	public int readFromBuffer(byte[] buffer, int offset);

	/**
	 * Write the Command Fragment to the input buffer
	 */
	public int writeToBuffer(byte[] buffer, int offset);
	
	/**
	 * Get the XML String from the buffer 
	 */
	public Vector getXMLFromBuf(String input);
	
	/**
	 * Set the Key Value pair of incoming XML command
	 * @param vlist
	 * @return
	 */
	public void setElemList(Vector vlist);
	
	/**
	 * Set the Key Value pair of incoming XML command
	 * @param vlist
	 * @return
	 */
	public Vector getElemList();
}

