/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *
 * $Id: ICommandHandler.java,v 1.2 2005/10/19 17:11:21 gnagarajan Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.util;

import org.eclipse.tptp.platform.execution.client.core.INode;

/**
 * This interface provides the interface for processing events.
 * 
 *
 * @since tptp 1.0 (no change)
 * 
 */
public interface ICommandHandler {

	/**
	 * This method is invoked when a response command or event is received
	 * Client applications need to implement this interface to create Command Handlers
	 * or Event Handlers.
	 */
	void incomingCommand(INode node, ICommandElement command);

}

