/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: TPTPAgentAccess.java,v 1.2 2005/10/03 22:22:14 gnagarajan Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.util;

/**
* This class provides a typesafe enumeration of possible Agent access modes.
* TPTP_CONTROLLER_ACCESS - This mode is used to request controller access to the specified agent
* TPTP_OBSERVER_ACCESS	- The flag is used to request observer access to the specified agent.
* TPTP_LOCK_AGENT -	This flag indicates that in addition to requesting access to the agent, the caller would like the agent to be locked so that other callers cannot share the agent. 
* TPTP_RUNNING_AGENTS_ONLY -This flag is used to obtain Agent reference of running agents only. 
* TPTP_CREATE_INSTANCE -This flag is used to indicate to obtain Agent reference by launching a new agent.
**/
public final class TPTPAgentAccess 
{
    int value = -1;
    TPTPAgentAccess(int value)
    {
        this.value = value;
    }
    public static final TPTPAgentAccess TPTP_CONTROLLER_ACCESS = new TPTPAgentAccess(0x0001);
    public static final TPTPAgentAccess TPTP_OBSERVER_ACCESS = new TPTPAgentAccess(0x0002);
    public static final TPTPAgentAccess TPTP_CREATE_INSTANCE = new TPTPAgentAccess(0x0004);
    public static final TPTPAgentAccess TPTP_RUNNING_AGENTS_ONLY = new TPTPAgentAccess(0x0008);
    public static final TPTPAgentAccess TPTP_LOCK_AGENT = new TPTPAgentAccess(0x0010);
    
    public int getValue()
    {
        return this.value;
    }
}
