/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: TPTPDataPath.java,v 1.3 2005/10/03 23:43:56 gnagarajan Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.util;

/**
 * Data path is the complete path that the data will take from a client to an agent, 
 * an agent to a client or an agent to another agent. 
 * The data path consists of two data connections bound together, this binding is enabled 
 * by the Agent Controller. 
 * This class contains the enumerations of values used to bind the data connections. 
 * 
 */
public class TPTPDataPath {
        int value = -1;
        TPTPDataPath(int value)
        {
            this.value = value;
        }
        public static final TPTPDataPath DATA_PATH_SEND = new TPTPDataPath(0x00000001);
        public static final TPTPDataPath DATA_PATH_RECEIVE = new TPTPDataPath(0x00000002);
        private static int data_path_two_way = DATA_PATH_SEND.getValue() | DATA_PATH_RECEIVE.getValue();
        public static final TPTPDataPath DATA_PATH_TWO_WAY = new TPTPDataPath(data_path_two_way);
         
        public int getValue()
        {
            return this.value;
        }
}
