/*******************************************************************************
 * Copyright (c) 2005,2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: Variable.java,v 1.4 2006/05/24 04:52:14 gnagarajan Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util;

/**
 * Variable Class (Represents the property of an agent)
 *
 * @since tptp 4.0
 * 
 */
public class Variable {

	/**
	 * ID of the variable
	 */
	private int _id;
	
	/**
	 * Variable Name
	 */
	private String _name;
	/**
	 * Variable Context
	 */
	private String _context;
	/**
	 * Variable Type - int, long, double, boolean, String, xsd etc.
	 */
	private int _type;
	
	/**
	 * Variable
	 */
	private Object _value;
	
	/**
	 * Access Type
	 * pre-run-only, during-run-only, paused-only, no-restrictions, never
	 * normal (not event based), single-state, value based
	 */
    private int _accessType;
    
    /**
     * Variable Description
     */
    private String _desc;

    /**
     * Variable enabled flag
     */
	private boolean _enabled;
	
	
	/**
	 * Default Constructor
	 */
	public Variable()
	{
			
	}
	
	/**
	 * Constructor with name, and value as parameters
	 */
	public Variable(String name, String value)
	{
		_name = name;
		//_type = 2;
		_value = value;
	}
	
	/**
	 * Constructor with name, type and value as parameters
	 */
	public Variable(String name, int type, Object value)
	{
		_name = name;
		_type = type;
		_value = value;
	}
	public Variable(String name, String value, String context)
	{
		_name = name;
		_context = context;
		_value = value;
	}
	
	/**
	 * Retrieve the ID of this variable.
	 */
	public int getID()
	{
		return _id;		
	}
	
	/**
	 * Set the ID of this variable.
	 */
	public void setID(int id)
	{
		_id = id;
	}
	
	
	/**
	 * Retrieve the type of this variable.
	 */
	public int getType()
	{
		return _type;
	}
	/**
	 * Retrieve the context of this variable.
	 */
	public String getContext()
	{
		return _context;
	}
	
	/**
	 * Set the type of this variable.
	 */
	public void setType(int type)
	{
		_type = type;
	}
	/**
	 * Set the type of this variable.
	 */
	public void setContext(String context)
	{
		_context = context;
	}
	/**
	 * Retrieve the name of this variable.
	 */
	public String getName()
	{
		return _name;		
	}
	
	/**
	 * Set the Name of this variable.
	 */
	public void setName(String name)
	{
		_name = name;
	}
	
	
	/**
	 * Retrieve the description of this variable.
	 */
	public String getDescription()
	{
		return _desc;		
	}
	
	/**
	 * Set the description of this variable.
	 */
	public void setDescription(String desc)
	{
		_desc = desc;
	}
	
	
	/**
	 * Retrieve the value of this variable.
	 */
	public Object getValue()
	{		
		return _value;
	}
	
	/**
	 * Set the value of this variable.
	 */
	public void setValue(Object value)
	{
		_value = value;
	}	

	
	/**
	 * Retrieve the access type of this variable.
	 */
	public int getAccessType()
	{		
		return _accessType;
	}
	
	/**
	 * Set the value of this variable.
	 */
	public void setAccessType(int accessType)
	{
		_accessType = accessType;
	}	
	
	/**
	 * Indicator whether this variable is enabled or not
	 */
	public boolean isEnabled()
	{
		return _enabled;
	}
}

