/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: VariableGroup.java,v 1.1 2005/09/29 21:39:18 gnagarajan Exp $ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.util;


/**
 * Variable Group interface (Represents the group of variables exposed by the Agent)
 *
 * @since tptp 4.0 (New Interface - in line with choreography requirements)
 * 
 * 
 */

//complex type to represent a variable group
public class VariableGroup {

    /**
     * Variable Group Unique ID
     */ 
	private int _id;
	
	/**
	 * Name of the Variable Group
	 */
	private String _name;
	
	/**
	 * Description of the Variable Group
	 */
	private String _desc;
	
	/**
	 * Variables in the Variable Group
	 */
	private Variable[] _variables;
	
	/**
	 * Sub Groups in the Variable Group
	 */
	private VariableGroup[] _subgroups;
	
	
	/**
	 * Constructor
	 */
	public VariableGroup()
	{
		
	}
	
	
	/**
	 * Retrieve the ID of this variable group.
	 */
	public int getID()
	{
		return _id;		
	}
	
	/**
	 * Set the ID of this variable group.
	 */
	public void setID(int id)
	{
		_id = id;
	}
  	
  	/**
  	 * Retrieve the name of this variable group.
  	 */
  	public String getName()
  	{
  		return _name;
  	}
  	
  	/**
  	 * Retrieve the name of this variable group.
  	 */
  	public void setName(String name)
  	{
  		_name = name;
  	}  	
  	
  	/**
  	 * Retrieve the description of this variable group.
  	 */
  	public String getDescription()
  	{
  		return _desc;
  	}
  	
  	
  	/**
  	 * Set the description of this variable group.
  	 */
  	public void setDescription(String desc)
  	{
  		_desc = desc;
  	} 
  	
  	/** 
  	 * Retrive the Variables in the group 
  	 */
  	public Variable[] getVariables()
  	{
  		return _variables;
  	}
  	
  	/** 
  	 * Set the Variables in the group 
  	 */
  	public void setVariables(Variable[] vars)
  	{
  		_variables = vars;
  	}
  	
  	/** 
  	 * Retrieve the sub groups of the variable group 
  	 */
  	public VariableGroup[] getSubGroups()
  	{
  		return _subgroups;
  	}
  	
  	/** 
  	 * Retrieve the sub groups of the variable group 
  	 */
  	public void setSubGroups(VariableGroup[] subgroups)
  	{
  		_subgroups = subgroups;
  	}
}
