/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.util.internal;

import org.eclipse.tptp.platform.execution.util.*;

/**
 * @provisional
 *
 */


public abstract class CommandElement implements ICommandElement, Constants {

	protected long _tag=0;
	protected long _context=0;

	protected long _dest=0;
	protected long _src=0;
	protected String _iid;

	/**
	 * CommandEntryElement constructor comment.
	 */
	public CommandElement() {
		super();
	}
	
	/**
	 * Get the CommandElement Context
	 */
	public long getContext() {
		return _context;
	}
	
	
	/**
	 * @see org.eclipse.tptp.platform.execution.util.ICommandElement#getSize()
	 */
	public abstract int getSize(); 

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setContextID(java.lang.String)
	 */
	public void setContext(long contextID) {
		_context = contextID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSrcID()
	 */
	public long getSource() {
		return _src;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
	 */
	public void setSource(long srcID) {
		_src = srcID;

	}
	
	public long getTag() {
		return _tag;
	}


	public long getDestination() {
		return _dest;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
	 */
	public String getInterfaceID() {
		return _iid;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
	 */
	public void setInterfaceID(String interfaceID) {
		_iid = interfaceID;
	}
	
	public void setDestination(long dest) {
		_dest=dest;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand(String srcID, String destID, String interfaceID,
			String cmdName, String ctxt, String processID, String agentID,
			String agentName) {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand(String srcID, String destID, String interfaceID,
			String cmdName, String ctxt) 
	{
		return null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand() 
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#readFromBuffer(byte[], int)
	 */
	public abstract int readFromBuffer(byte[] buffer, int offset);

	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#writeToBuffer(byte[], int)
	 */
	public abstract int writeToBuffer(byte[] buffer, int offset);

}
