/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.util.internal;

import java.util.Vector;
import org.eclipse.tptp.platform.execution.util.*;

/**
 * The CommandFragment represents a generic command that is build and recieved 
 * by the client.
 * @provisional
 * @since TPTP 4.0
 *
 *
 */

public class CommandFragment extends CommandElement implements ICommandFragment 
{

	protected TPTPString _commandData;
	protected TPTPString _commandName;
	protected Vector 	 _elemList = new Vector();
	public CommandFragment(){
		super();
		_commandData = new TPTPString();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandFragment#setCommand(java.lang.String)
	 */
	public void setCommand(String command) {
		_commandData = new TPTPString(command);
	}
	public void setCommandName(String command)
	{
	    this._commandName = new TPTPString(command);
	}
	public String getCommandName()
	{
	    return (this._commandName).getData();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandFragment#getCommandData()
	 */
	public String getCommandData() {
		return _commandData.getData();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current=offset;//super.readFromBuffer(buffer, offset);
		current=TPTPMessageUtil.readTPTPCmdStringFromBuffer(buffer, current, _commandData);
		return current;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current=offset;//super.writeToBuffer(buffer, offset);
		current=TPTPMessageUtil.writeTPTPCmdStringToBuffer(buffer, current, _commandData);
		return current;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandFragment#getXMLFromBuf(java.lang.String)
	 */
	public Vector getXMLFromBuf(String input) {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSize()
	 */
	public int getSize() {
		int size = 0;
		size = TPTPMessageUtil.getTPTPCmdStringSize(_commandData);
		return size;
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand(String srcID, String destID, String interfaceID,
			String cmdName, String ctxt, String processID, String agentID,
			String agentName) {
		return null;
	}
	
	public String buildCommand()
	{
		StringBuffer CommandBuffer = new StringBuffer();
		
		if (this._commandData != null)
		{
			CommandBuffer.append("<Cmd dest=\"");
			CommandBuffer.append(this.getDestination());
			CommandBuffer.append("\" src=\"");
			CommandBuffer.append(this.getSource());
			CommandBuffer.append("\" ctxt=\"");
			CommandBuffer.append(this.getContext());
			CommandBuffer.append("\">");
					
			CommandBuffer.append(_commandData.getData());			
			CommandBuffer.append("</Cmd>");			
		}
		
		this._commandData = new TPTPString(CommandBuffer.toString());
		
		return CommandBuffer.toString();
	}
	public long getSource() 
	{
		return _src;
	}
	public String getInterfaceID() {
		return _iid;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
	 */
	public void setInterfaceID(String interfaceID) {
		_iid = interfaceID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
	 */
	public void setSource(int srcID) 
	{
		_src = srcID;
	}
	
	public long getDestination() 
	{
		return _dest;
	}
	public void setDestination(int dest) {
		this._dest = dest;
	}
	public long getContext() 
	{
		return _context;
	}
	public void setContext(int ctxt) 
	{
		this._context = ctxt;
	}
	public void setElemList(Vector vlist)
	{
	    this._elemList = vlist;
	}
	public Vector getElemList()
	{
	    return this._elemList;
	}
}
