/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi, Intel - Initial API and implementation
 *    Guru Nagarajan, Intel - Initial API and implementation
 * 
 * $Id$ 
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.util.internal;

/**
 * PlaceHolder for TPTP new Exec Client constants
 */
public interface Constants {

	/* Various Message types currently available */
	public static final byte RA_ACKNOWLEDGEMENT_MESSAGE			=0x00000000;
	public static final byte RA_CONTROL_MESSAGE					=0x00000001;

	public final static long RA_MAGIC							=0x82656780;	
	public final static long RA_VERSION							=0x00000100;

	/* The various COMMAND_ID's types from the client (server targeted flows) */
	public final static long RA_AUTHENTICATE					=0x00000001;
	public final static long RA_LAUNCH_PROCESS					=0x00000010;
	public final static long RA_KILL_PROCESS					=0x0000001B;
	public final static long RA_QUERY_PROCESS_LIST				=0x00000011;
	public final static long RA_QUERY_AGENT_LIST				=0x00000012;
	public final static long RA_QUERY_AGENT_DETAILS				=0x0000001C;
	public final static long RA_REGISTER_AGENT_NOTIFICATION		=0x00000013;
	public final static long RA_ATTACH_TO_AGENT					=0x00000014;
	public final static long RA_DETACH_FROM_AGENT				=0x00000015;
	public final static long RA_START_MONITORING_AGENT_REMOTE	=0x00000016;
	public final static long RA_START_MONITORING_AGENT_LOCAL	=0x00000017;
	public final static long RA_STOP_MONITORING_AGENT			=0x00000018;
	public final static long RA_SET_NAME_VALUE_PAIR				=0x00000019;
	public final static long RA_GET_PROPERTY_LIST				=0x0000001E;
	public final static long RA_MANAGE_FILE						=0x0000001F;

	/* The extension point for custom protocol piggy-backing */
	public final static long RA_CUSTOM_COMMAND					=0x0000001A;
    public final static long RA_BINARY_CUSTOM_COMMAND			=0x0000001D;

	/* The various COMMAND_ID's from the Remoteable Agent Controller (client targeted flows) */
	public final static long RA_AUTHENTICATION_FAILED			=0x00000002;
	public final static long RA_AUTHENTICATION_SUCCESSFUL		=0x00000003;
	public final static long RA_SERVER_SECURITY_REQUIREMENTS	=0x00000004;
	public final static long RA_PROCESS_LAUNCHED				=0x00000020;
	public final static long RA_PROCESS_EXITED					=0x00000029;
	public final static long RA_PROCESS_LIST					=0x00000021;
	public final static long RA_AGENT_LIST						=0x00000022;
	public final static long RA_AGENT_ACTIVE					=0x00000023;
	public final static long RA_AGENT_INACTIVE					=0x00000024;
	public final static long RA_AGENT_DETAILS					=0x00000028;
	public final static long RA_ERROR_STRING					=0x00000025;
	public final static long RA_CONTROLLER_REQUEST_MONITOR		=0x00000062;
	public final static long RA_PROPERTY_LIST					=0x0000002A;

	public final static long RA_AGENT_QUERY_STATE				=0x0000002B; // Bug 54376
	public final static long RA_AGENT_ATTACHED					=0x0000002C; // Bug 54376
	public final static long RA_AGENT_DETACHED					=0x0000002D; // Bug 54376

	public final static long RA_RESOURCE_LOCATION				=0x00000070;
	/**
 	  * Various constants that both the client and server must adhere to.
 	  */
	public final static int CTL_PORT_NUM_SERVER			=10002; /* hardcoded to start with */
	public final static int CTL_PORT_NUM_CLIENT			=10003; /* hardcoded to start with */
	public final static int MESSAGE_HEADER_LENGTH		=10;		/* 10 byte header to start with */
	public final static int MAX_MESSAGE_LENGTH			=8192;	/* The maximum size of a message */
	public final static int MAX_COMMAND_LINE_LENGTH		=512;	/* Maximum length of a command line string */
	public final static int DATA_PORT_NUM_CLIENT		=10004;
	public final static int MAX_DATA_LENGTH				=4096;	/* The size of the data buffer for sockets */
	public final static int ACK_HDR_LEN					=12;	/* The size of the data buffer for sockets */
	

	/* This package is ported from C, so to facilitate sizeof code for primitives
	   the following constants are provided */

	public final static int sizeofByte					=1;
	public static final int sizeofChar					=2;
	public static final int sizeofShort					=2;
	public static final int	sizeofLong					=4;

	public static final int TPTP_RAC_MESSAGE			=1;
	public static final int TPTP_AC_MESSAGE				=2;
	public final static long AC_MAGIC_NUMBER			=0x54B674DE;
	public static final int  AC_MESSAGE_HEADER_SIZE     =8; 
	public static final int  RAC_MESSAGE_HEADER_SIZE    =16; 
	
	public static final long MD5_PRESENT               	=0x00000001;
	public static final long CONNECT                   	=0x01000000;
	public static final long DISCONNECT                	=0x02000000;
	public static final long CONNECTION_COMPLETE       	=0x04000000;
	public static final long CONNECTION_RECONNECT_REQUEST = 0x09000000;
	public static final long CONNECTION_REFUSED        	=0x08000000;
	public static final long CONNECT_DATA              	=0x10000000;
	public static final long DATA_CONNECTION_COMPLETE  	=0x20000000;
	public static final long DATA_CONNECTION_REFUSED   	=0x40000000;
	
	public static final long SECURITY_REQUIRED   		=0x00010000;
	public static final long AUTHENTICATE   			=0x00020000;
	public static final long AUTHENTICATION_FAILED   	=0x00040000;
	public static final long AUTHENTICATION_SUCCESSFUL  =0x00080000;
	
	public static final long DATA_PATH_SEND				=0x00000001;
	public static final long DATA_PATH_RECEIVE 			=0x00000002;
	public static final long DATA_PATH_TWO_WAY 			= DATA_PATH_SEND | DATA_PATH_RECEIVE;
	
	
	//TPTP 4.0 AC Defined Interface ID's & Destination ID
    public static final String AGNT_MGR_IID              = "org.eclipse.tptp.agentManager";
    public static final String PID_TAG             		 = "processID";
    public static final String GETAGENT_TAG       	 	 = "getAgent";
    public static final String GETAGENT_TOK_TAG       	 = "getAgentByToken";
    public static final String GETAGENT_ID_TAG       	 = "getAgentByID";
	public final static int AC_DEST_ID					 = 1;
	public static final String GENERIC_EVNT_IID 	     = "org.eclipse.tptp.eventProvider";
	
    //TPTP 4.0 AC - The following are tptpProcessController specific constants
	public static final String PROCCTLR_AGENT_NAME       = "ProcessController";
    public static final String PROC_CTLR_IID             = "org.eclipse.tptp.processController";
    public static final String PROC_CTLR_EVNT_IID 	     = "org.eclipse.tptp.eventProvider";
    public static final String startProcess_Cmd		 	 = "startProcess";
    public static final String processStarted_Cmd		 = "processStarted";
    public static final String stopProcess_Cmd		 	 = "stopProcess";
    public static final String processStopped_Cmd		 = "processTerminated";
    public static final String validateProcessToLaunch_Cmd	= "validateProcessToLaunch";
    public static final String processValidationResults_Cmd	= "processValidationResults";
    public static final String processExited_Cmd		 = "processExitedEvent";
    public static final String agentProcessExited_Cmd		 = "agentProcessExited";
    
    public static final String validApp_Ret				 = "0";
    public static final String validWorkingDir_Ret		 = "0";
		
	//Used for QueryAvailable Agents Command
	public static final String queryAvailableAgents_Cmd	 = "queryAvailableAgents";
	public static final String availableAgents_Cmd	 	 = "availableAgents";
	public static final String agentNames_TAG			 = "agentNames";
	//Used for QueryRunning Agents Command	
	public static final String queryRunningAgents_Cmd	 = "queryRunningAgents";
	public static final String runningAgents_Cmd	 	 = "runningAgents";
	public static final String agentIDs_TAG			 	 = "agentID";
	//Used for AgentMetaData Command
	public static final String getAgentMetadata_Cmd	 	 = "getAgentMetadata";
	public static final String agentMetadata_Cmd	 	 = "agentMetadata";
	public static final String metadata_TAG			 	 = "metadata";
	//Used for AgentRegistry Command
	public static final String getAgentRegistry_Cmd	 	 = "getAgentRegistry";
	public static final String agentRegistry_Cmd	 	 = "agentRegistry";
	public static final String interfaces_TAG			 = "interfaces";
	//Used for GetAgent Command
	public static final String getAgent_Cmd	 	 		 = "getAgent";
	public static final String agentReference_Cmd	 	 = "agentReference";
	public static final String agentID_TAG			 	 = "agentID";
	public static final String agentUnavailable_TAG		 = "agentUnavailable";
	public static final String Reason_TAG		 		 = "Reason";
	//Used for GetSpecificAgent Command
	public static final String getSpecificAgent_Cmd	 	 = "getSpecificAgent";
	//The getspecific agent command will return a Cmd Response of "agentReference"
	//It will contain a AgentID tag 
	//If not available then an "agentUnavailable" Cmd response will be issued
	//the agent unavailable will contain a reason tag if it returns an AgentUnavailable command
	//Used for AttachToAgent Command
	public static final String attachToAgent_Cmd	 	= "attachToAgent";
	public static final String agentAttachedSuccessful_Cmd	= "agentAttachedSuccessful";
	public static final String agentAttachDenied_TAG	= "agentAttachDenied";
	//the agentattachdenied will include a response tag for mesg.
	//Used for DetachFromAgent Command -- no response for this command
	public static final String detachFromAgent_Cmd	 	= "detachFromAgent";
	//Used for ReleaseAgent Command -- no response for this command
	public static final String releaseAgent_Cmd	 	 	= "releaseAgent";
	public static final String releaseAgentControl_Cmd	= "releaseControl";
	public static final String requestAgentControl_Cmd	= "requestControl";
	public static final String agentControlGranted_Cmd	= "controlGranted";

	//This will be used with the Agent_MGR_EVENT interface to recv. event notification
	public static final String agentRegistered_Cmd	 	= "agentRegistered";
	public static final String agentDeregistered_Cmd	= "agentDeregistered";
	public static final String agentAvailable_Cmd		= "agentAvailable";
	public static final String agentUnavailable_Cmd		= "agentUnavailable";
	
	//TPTP 4.0 Commands/data tags For the TPTP Command Protocol
    public static final String CMD_XML_BEGIN_TAG = "<Cmd ";
    public static final String SRC_XML_ATTR_TAG = "src= ";
    public static final String CTX_XML_ATTR_TAG = "ctx= ";
    public static final String DEST_XML_ATTR_TAG = "dest= ";
    public static final String CMD_XML_CLS_TAG = "</Cmd>";
    public static final String XML_CLS_TAG = ">";     
    
	public static final String TPTP_CBE_ERROR	  = "CommonBaseEvent";
	public static final boolean TPTP_DEBUG	  	  = false;
	
	//Constants for the DIME header and body field 
	//Basically the positions in the DIME data for the specific fields
	public static final int DIME_HEADER_LEN 		= 12;
	public static final int DIME_CONSOLE_PID_LEN 	= 4;
	public static final char DIME_TPTP_STDIN		= 'I';
	public static final char DIME_TPTP_STDOUT		= 'O';
	public static final char DIME_TPTP_STDERR		= 'E';
	public static final char DIME_TPTP_DP_DEF		= 'U';
	
	public static final int TIMEOUT_PERIOD			= 100;
	public static final int PROCESS_LAUNCH_TIMEOUT_TRY_COUNT	= 50;
	public static final int DSSRVR_LAUNCH_TIMEOUT_TRY_COUNT		= 1000;
	public static final int CONNECT_TIMEOUT_TRY_COUNT = 32;
	public static final int WAIT_RESPONCE_TIMEOUT = 10000;
	
	public static final boolean TPTP_AC					= true;

	//Agent Access Mode
	public static final int TPTP_CONTROLLER_ACCESS 	 = 0x0001;
	public static final int TPTP_OBSERVER_ACCESS 	 = 0x0002;
	public static final int TPTP_CREATE_INSTANCE 	 = 0x0004;
	public static final int TPTP_RUNNING_AGENTS_ONLY = 0x0008;
	public static final int TPTP_LOCK_AGENT 		 = 0x0010;
	
	public static final String ERR_NOT_SUPPORTED		 = "The implementation of this method is not supported in this version of the execution framework";
	
	
	// Client messages
	public static final String TPTP_PLATFORM_EXEC_MSG1 = "Error: Unable to send the command to agent as it is not active.";
	public static final String TPTP_PLATFORM_EXEC_MSG2 = "Agent Name required for querying meta data.";
	public static final String TPTP_PLATFORM_EXEC_MSG3 = "The command execution failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG4 = "Error: Unable to stop monitoring the agent. The agent is inactive.";
	public static final String TPTP_PLATFORM_EXEC_MSG5 = "Error: Unable to publish the configuration for the agent. The agent is inactive.";
	public static final String TPTP_PLATFORM_EXEC_MSG6 = "Authentication failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG7 = "Unable to get a reference to the agent. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG8 = "The query deployed agents command execution failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG9 = "The query agent by processID failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG10 = "The release agent command execution failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG11 = "The request agent command execution failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG12 = "The release agent control command execution failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG13 = "Unable to retrieve the list of agents. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG14 = "Unable to retrieve the list of processes. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG15 = "Unable to retrieve the process information. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG16 = "Unable to retrieve the available agents list. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG17 = "Unable to retrive the running agent list. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG18 = "Unable to query the agent metadata. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG19 = "Adding generic listener for commands failed. The agent is not active.";
	public static final String TPTP_PLATFORM_EXEC_MSG20 = "Agent Process Exited.";
	public static final String TPTP_PLATFORM_EXEC_MSG21 = "Error: Connection Timed out.";
	public static final String TPTP_PLATFORM_EXEC_MSG22 = "Error: Unable to connect to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG23 = "Error launching the process. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG24 = "Error launching the process. The process is already active.";
	public static final String TPTP_PLATFORM_EXEC_MSG25 = "Error: Unable to kill the process. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG26 = "Error: Unable to kill the process. The process is no longer active.";
	public static final String TPTP_PLATFORM_EXEC_MSG27 = "Error: Unable to validate the process. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG28 = "Error: Unable to validate the process. The agent is no longer active.";
	public static final String TPTP_PLATFORM_EXEC_MSG29 = "Error: The agent is inactive.";
	public static final String TPTP_PLATFORM_EXEC_MSG30 = "Error: Set environment variable failed. The process is already active.";
	public static final String TPTP_PLATFORM_EXEC_MSG31 = "Error: remove environment variable failed. The process is still active.";
	public static final String TPTP_PLATFORM_EXEC_MSG32 = "Error: process launch command execution failed. The agent is inactive.";
	public static final String TPTP_PLATFORM_EXEC_MSG33 = "Launching Process command timed out.";
	public static final String TPTP_PLATFORM_EXEC_MSG34 = "Error: The process launch command execution failed. There is no such application. The error code and error info - ";
	public static final String TPTP_PLATFORM_EXEC_MSG35 = "Error: process launch command execution failed. The process is already active.";
	public static final String TPTP_PLATFORM_EXEC_MSG36 = "Error: launch process command execution failed. There is no such application.";
	public static final String TPTP_PLATFORM_EXEC_MSG37 = "Error: launch process command execution failed. The Client is not connected to the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG39 = "Error: Unable to connect to the Agent Controller. The Agent Controller is not trusted.";
	public static final String TPTP_PLATFORM_EXEC_MSG40 = "Could not get an SSLContext. All protocol specifications were tried.";
	public static final String TPTP_PLATFORM_EXEC_MSG41 = "Error: The native library not found.";
	public static final String TPTP_PLATFORM_EXEC_MSG42 = "Error: Unable to register with the Agent Controller.";
	public static final String TPTP_PLATFORM_EXEC_MSG43 = "Error: Unable to send the data. The Agent Controller is not available.";
	public static final String TPTP_PLATFORM_EXEC_MSG44 = "Error: Timed out waiting for response from the Agent Controller.";
	
	
	
}
