
/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.util.internal;

import java.util.BitSet;

import org.eclipse.tptp.platform.execution.exceptions.DataChannelConnectionException;


public class DimeHeader
{
	
	private int version;
	private boolean mb;
	private boolean me;
	private boolean cf;
	private int type_t;
	private int reserved;
	private int options_length;
	private int id_length;
	private int type_length;
	private long data_length;
	
	public DimeHeader() {
		super();
		
		version = 0;
		mb = false;
		me = false;
		cf = false;
		type_t = 0;
		reserved = 0;
		options_length = 0;
		id_length = 0;
		type_length = 0;
		data_length = 0;
		// TODO Auto-generated constructor stub
	}
	
	
	public static DimeHeader getDIMEHeader(byte[] buffer)
	{
		DimeHeader dimeheader = new DimeHeader();
		
		if (buffer.length < Constants.DIME_HEADER_LEN)
			return null;
		
		//Read the flags
		if ((buffer[0]>>5 & 0x00000001) == 0x00000001)
		{
			dimeheader.mb = true;
		}
		if ((buffer[0]>>6 & 0x00000001) == 0x00000001)
		{
			dimeheader.me = true;
		}
		if ((buffer[0]>>7 & 0x00000001) == 0x00000001)
		{
			dimeheader.cf = true;
		}
		
		//Read options length
		dimeheader.options_length = (int)(buffer[3] & 0x00ff)
		  |(int)(buffer[2]<<8 & 0xff00);		
		
		//Read id length
		dimeheader.id_length = (int)(buffer[5] & 0x00ff)
		  |(int)(buffer[4]<<8 & 0xff00);		
		
		
		//Read type length
		dimeheader.type_length = (int)(buffer[7] & 0x00ff)
		  |(int)(buffer[6]<<8 & 0xff00);		
		
		//Read data length
		dimeheader.data_length =  (long)(buffer[11] & 0x000000ff)
		  |(long)(buffer[10]<<8 & 0x0000ff00)
		  |(long)(buffer[9]<<16  & 0x00ff0000)
		  |(long)(buffer[8]<<24     & 0xff000000);
		
		
		return dimeheader;
	}
	
	public int getVersion()
	{
		return version;
	}
	
	public boolean getMB()
	{
		return mb;
	}
	
	public boolean getME()
	{
		return me;
	}
	
	public boolean getCF()
	{
		return cf;
	}
	
	public int getTypeT()
	{
		return type_t;
	}
	
	public int getReserved()
	{
		return reserved;
	}
	
	public int getOptionsLength()
	{
		return options_length;
	}
	
	public int getIDLength()
	{
		return id_length;
	}
	
	public int getTypeLength()
	{
		return type_length;
	}
	
	public long getDataLength()
	{
		return data_length;
	}
	public static char[] writeConsoleData(char[] buffer, long processID, char consoleType)
	{
		int longLength = Constants.sizeofLong;
		int consoleDimeBufLen = Constants.DIME_HEADER_LEN + Constants.sizeofLong+buffer.length;
		char consoleDimeBuf[] = new char[consoleDimeBufLen];
			
		for(int c = 0; c < buffer.length; c++)
		{
		    consoleDimeBuf[c] = buffer[c];  
		}
		return consoleDimeBuf;
	}
		
	public static byte[] shipIt(byte [] buffer, int dataLength) 
	{
		int buffersize = Constants.DIME_HEADER_LEN + dataLength; 
		
		byte newbuffer[] = new byte[buffersize];
		int offset = 0;
		try {
			offset = TPTPMessageUtil.writeTPTPLongToBuffer(newbuffer, offset, 0<<8);
			offset = TPTPMessageUtil.writeTPTPLongToBuffer(newbuffer, offset, 0<<8);
			offset = TPTPMessageUtil.writeTPTPLongToBuffer(newbuffer, offset, dataLength);
		
			System.arraycopy(buffer, 0, newbuffer, offset, dataLength);
			return newbuffer;
		}
		catch(Exception e) {
			
			return null;
		}
	}
}
