/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util.internal;


/**
 * IMessage interface - Represents the Message Header of the message protocol
 * between and Client and Agent Controller or Agent Controller and Agent. 
 *
 * @since tptp 1.0 (Some changes for the new message protocol)
 * 
 * 
 * @see org.eclipse.hyades.internal.execution.local.common.Message
 * 
 */
public interface IMessage {
	
	/**
	 * Get the Size of the Message
	 */
	public int getSize() ;
	
	/**
	 * Get the Ticket
	 */
	public long getTicket() ;
	
	/**
	 * Get the Message Type - Old RAC or New AC Message
	 */
	public long getType() ;
	
	/**
	 * Get Version
	 */
	public long getVersion() ;
	
	/**
	 * Set the Ticket
	 */
	public void setTicket(long ticket) ;
	
	/**
	 * Set Version Number 
	 */
	public void setVersion(long version);
	
	/**
	 * Read the message header from the input buffer 
	 */
	public int readFromBuffer(byte[] buffer, int offset);
	
	/**
	 * Write the message header to the input buffer 
	 */
	public int writeToBuffer(byte[] buffer, int offset) ;
}
