/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *    Andy Kaylor, Intel - Removed support for RAC commands
 *
 * $Id$ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util.internal;

/**
 * Interface providing support message processing.
 *
 */
public class Message implements IMessage, Constants {

	/* The protocol magic number */
	protected long _magic=0;
	
	/* The protocol version number */
	protected long _version=RA_VERSION;

	/* Length of the message */
	protected long _type=0;

	/* The ticket number of the message */
	protected long _ticket=0;

	/* For New AC Message - Flags */
	protected long _flags = 0;

	/* Message Type */
	protected long _messageType = TPTP_RAC_MESSAGE;//Old RAC Format- OLD_RAC_MESSAGE(1), New RAC Format - NEW_AC_MESSAGE(2)

	
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getSize()
	 */
	public int getSize() {
		int size = 0;

		size = 2*sizeofLong;

		return size;
	}
	
	public void setMagicNumber(long magic) {		
		_magic = magic;
	}
	
	public long getMagicNumber() {
		return _magic;
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getTicket()
	 */
	public long getTicket() {
		return _ticket;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getType()
	 */
	public long getType() {
		return _type;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getVersion()
	 */
	public long getVersion() {
		return _version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#setTicket(long)
	 */
	public void setTicket(long ticket) {		
		_ticket = ticket;
	}
	
	public long getMessageType() {
		return _messageType;
	}
	
	public void setMessageType(long messageType) {
		_messageType = messageType;
	}
	
	public long getFlags() {
		return _flags;
	}
	
	public void setFlags(long flags) {
		_flags = flags;
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#setVersion(long)
	 */
	public void setVersion(long version) {		
		_version = version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {		
		/* magic number */
		_magic = TPTPMessageUtil.readTPTPLongFromBuffer(buffer, offset);
		offset+=4;

		/* version */
		_flags=TPTPMessageUtil.readTPTPLongFromBuffer(buffer, offset);
		offset+=4;
		_type=1;

		return offset;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		
		int current=offset;
		
		/* Insert magic header */
		current=TPTPMessageUtil.writeTPTPLongToBuffer(buffer, current, Constants.AC_MAGIC_NUMBER);
		current=TPTPMessageUtil.writeTPTPLongToBuffer(buffer, current, _flags);
		_type = 1;

		return current;
	}
}
