/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util.internal;

import java.util.*;
import java.io.StringReader;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
/**
 * @author gnagaraj
 *
 * 
 */
public class SAXFragmentParser extends DefaultHandler
{
	private static String currentElement = null;
	private static String currentValue = null;
	private static Hashtable htable =new Hashtable();
	
	public static String setParser(String input)
	{
		DefaultHandler handler = new SAXFragmentParser();
		SAXParserFactory factory = SAXParserFactory.newInstance();
		InputSource 	 is 	 = new InputSource(new StringReader(input));
		String 			 agentVal = null;
		try{
			SAXParser parser = factory.newSAXParser();
			parser.parse(is, handler);
			if((htable.size())> 0){	agentVal = (String)htable.get("agentID");}
	
		}
		catch (Throwable e){e.printStackTrace();}
		
		return agentVal;
	}
	public void startDocument() throws SAXException {}
	
	public void endDocument()
	throws SAXException
	{
	  try {System.out.println(); } catch (Exception e) {
	    throw new SAXException("I/O error", e);
	  }
	} 
	public void startElement(String namespaceURI, String sName, String qName, Attributes attrs)
	throws SAXException
	{
		currentElement = qName; 
		
	  /*if (attrs != null) {
	    for (int i = 0; i < attrs.getLength(); i++) {
	      String aName = attrs.getLocalName(i); 
	      System.out.println("Attribute: " + aName + " = " +attrs.getValue(i));
	    }
	  }
	  */
	}
	public void characters(char[] ch, int start, int length)
	throws SAXException
	{		currentValue = new String(ch, start, length);	}
	
	public void endElement(String namespaceURI, String sName, String qName)
	throws SAXException
	{
		if(qName.equals("agentID")){htable.put(currentElement,currentValue);}
	} 


	
}
