/*******************************************************************************
 * Copyright (c) 2005,2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: SampleClientRAC.java,v 1.2 2006/04/05 00:57:59 gnagarajan Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.util.internal;

import org.eclipse.tptp.platform.execution.client.agent.*;
import org.eclipse.tptp.platform.execution.client.core.*;

public class SampleClientRAC implements IDataProcessor
{

	private String agentName = "";
	private String hostName = "127.0.0.1";
	private int port = 10002;
	private long processId = 0;
	
	public void incomingData(byte[] buffer, int length, java.net.InetAddress peer)
	{
		System.out.println("Data Processor Called");
		String data = new String(buffer);
		System.out.println("The Data received from " + agentName + " - " + data);
	}
	
	public void incomingData(char[] buffer, int length, java.net.InetAddress peer)
	{
		System.out.println("Data Processor Called");
	}
	
	public void invalidDataType(byte[] data, int length, java.net.InetAddress peer)
	{
		System.out.println("Data Processor Called");
	}
	
	public void waitingForData()
	{
		System.out.println("Data Processor Called");
	}
	
	public SampleClientRAC()
	{

	}

	public static void main(String[] args)
	{

		SampleClientRAC TestClientForRAC = new SampleClientRAC();
		// Get the Command Line Parameters
		if (args.length == 4)
		{
			if (args.length >= 1)
			{
				TestClientForRAC.hostName = args[0];
			}
			if (args.length >=2)
			{
				TestClientForRAC.port = (new Integer(args[1])).intValue();
			}
			if (args.length >=3)
			{
				TestClientForRAC.agentName = args[2];
			}
			if (args.length >=4)
			{
				TestClientForRAC.processId = Long.parseLong(args[3]);
			}
		}
		else
		{
			System.out.println("Can not run the Sample Program - Usage: java SampleClientRAC <hostname> <port> <agentName> <processid>");
		}

		//Create a Node that represents the target machine and agent controller
		INode SampleNode = null;
		IAgentController ac = null;
		ConnectionInfo connInfo = new ConnectionInfo();

		try
		{
			//Create a Node that represents the target machine and agent controller
			SampleNode = NodeFactory.createNode(TestClientForRAC.hostName);			
			connInfo.setHostName(TestClientForRAC.hostName);
			connInfo.setPort(TestClientForRAC.port);
			
			/*if (SampleNode != null)
			{
				// Connect to the Agent Controller
				ac = SampleNode.connect(connInfo);
				System.out.println("Connected to " + TestClientForRAC.hostName + " at port number " + TestClientForRAC.port);

				//Get an instance of Agent, currently deal with agentid directly		
				IAgent agent = null;
				//agent = (ILocalAgent)ac.getAgent("PerfmonAgent - #1115400122157", "org.eclipse.tptp.platform.execution.agent.IAgent");
				agent = (IAgent)ac.getAgent(TestClientForRAC.agentName, TestClientForRAC.processId);				
				
				//IProcess PerfMonProcess = ac.createProcess();
				//PerfMonProcess.setProcessId("3292");
				//agent.setProcess(PerfMonProcess);
				//agent.setName("PerfmonAgent - #1115341541306");
				agent.attach();
				agent.startMonitoring(TestClientForRAC);				

				Thread.sleep(5000);
				
				agent.stopMonitoring();				
 
				while(true){}
			}
			else
			{
				System.out.println("Error occurred while creating the Node for " + TestClientForRAC.hostName);
			}*/
		}
		catch(Exception exp)
		{
			System.out.println("Error occurred while connecting to " + TestClientForRAC.hostName + ":" + exp);
		}
	}

}