/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.util.internal;

import java.util.*;


public class TPTPString  {

	protected String _data="";
	protected int _padding=0;

public TPTPString() {
	super();
}

public TPTPString(String data) {
	if(data!=null) {
		_data=data;
		calculatePadding();
	}
	else {
		_data="";
		_padding=0;
	}
}

private void calculatePadding() {
	try {
		_padding=4-_data.getBytes("UTF-8").length%4;
		if(_padding==4) {
			_padding=0;
		}
	}
	catch(Exception e) {
		_padding=4-_data.length()%4;
		if(_padding==4) {
			_padding=0;
		}
	}
}

public String getData() {
	return _data;
}

public int getPadding() {
	return _padding;
}

/**
 * Returns String size + length of the long representing the string length
 * @return
 */
public int getSize() {
	try {
		return Constants.sizeofLong+_data.getBytes("UTF-8").length+_padding;
	}
	catch(Throwable e) {
		return Constants.sizeofLong+_data.length()+_padding;
	}
}

/**
 * Returns just the length of the String (doesn't include the long that represents the length of the string)
 * @return
 */
public int getStringSize() {
	try {
		return _data.getBytes("UTF-8").length+_padding;
	}
	catch(Throwable e) {
		return _data.length()+_padding;
	}
}

public long length() {
	if(_data!=null)
		return _data.length();

	return 0;
}

public void setData(String data) {
	_data=data;
	calculatePadding();
}

public static String[] tokenizeString(String token, String input)
{
     StringTokenizer tok = new StringTokenizer(input, token);
     Vector vector = new Vector();
     while (tok.hasMoreTokens()) 
     { vector.add(tok.nextToken());}
     String[] ret = new String[vector.size()];
     for(int i = 0; i < vector.size(); i++)
     { ret[i] = (String)vector.elementAt(i);}
     return ret;
}

}
