/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Guru Nagarajan, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.util.internal;

import java.util.*;
import java.io.StringReader;

import javax.xml.parsers.*;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import java.lang.reflect.*;
import org.w3c.dom.*;
import org.eclipse.tptp.platform.execution.util.Variable;

public class TPTPXMLParse extends DefaultHandler
{
	private String currentElement 	= null;
	private String currentValue 	= null;
	private Hashtable<String, String> htable = new Hashtable<String, String>();
	private Vector<Variable> vector 		 = new Vector<Variable>();
	private Method 	selectNodeList	= null;
	private Method 	selectSingleNode	= null;
	private final static String JAXP_NL_METHOD_NAME = "selectNodeList";
	private final static String JAXP_ND_METHOD_NAME = "selectSingleNode";
	private Object object = null;
		
	public TPTPXMLParse()
	{
		/* Using reflection since the Eclipse runtime packaging is not guaranteed to include the Apache Xerces base. 
		 * Adding a plugin dependency for Apache is the right thing to do.  
		 * I did not find the plugin though in Eclipse 3.0 and 3.1 and hence using Reflection - there is a going to be a performance
		 * hit due to this - but if it gets bad, then remove the reflection and use direct classes - Guru Nagarajan, 3.23.06
		 * */

		boolean clazzfound = false;
		Class XPathAPI = null;
	    try 
	    {
	        XPathAPI = Class.forName("org.apache.xpath.XPathAPI");
	        clazzfound = true;
	    } 
	    catch (ClassNotFoundException e) 
	    {
	        try {
	        		XPathAPI = Class.forName("com.sun.org.apache.xpath.internal.XPathAPI");
	        		clazzfound = true;
	        	} 
	        catch (ClassNotFoundException e1) 
	        {
	        }
	    }

		if(clazzfound)
		{
			try {
		          	//object 		= clazz.newInstance();
		          	Class[] paramNLTypes = new Class[] {Node.class, String.class };
		          	Class[] paramSNTypes = new Class[] {Node.class, String.class };
		          	selectNodeList 		= XPathAPI.getMethod(JAXP_NL_METHOD_NAME, paramNLTypes);
		          	selectSingleNode 	= XPathAPI.getMethod(JAXP_ND_METHOD_NAME, paramSNTypes);
		      	} 
				//catch (InstantiationException e){ System.out.println(e);} 
				//catch (IllegalAccessException e){ System.out.println(e);} 
				catch (Exception e){ System.out.println(e);}
		}
	}
	
	public void setParser(String input)
	{
		DefaultHandler handler = this;
		SAXParserFactory factory = SAXParserFactory.newInstance();
		InputSource 	 is 	 = new InputSource(new StringReader(input));
		try{
			SAXParser parser = factory.newSAXParser();
			parser.parse(is, handler);
			//if((htable.size())> 0){	agentVal = (String)htable.get("agentID");}
		}
		catch (Throwable e){
			System.err.println("FAILED ON INPUT>>> " + input);
			System.err.println("<<<");
			e.printStackTrace();
			}
		
		//return agentVal;
	}
	public void startDocument() throws SAXException {}
	
	public void endDocument()
	throws SAXException
	{
		
	} 
	public void startElement(String namespaceURI, String sName, String qName, Attributes attrs)
	throws SAXException
	{
		this.currentElement = qName; 
		this.currentValue	= null;
		if (attrs != null) {
	    for (int i = 0; i < attrs.getLength(); i++) 
	    {
	      String aName = attrs.getQName(i); 
	      Variable var = new Variable(aName, attrs.getValue(i));
	      vector.add(var);
	    }
	  }
	 
	}
	public void characters(char[] ch, int start, int length)
	throws SAXException
	{		this.currentValue = new String(ch, start, length);	}
	
	public void endElement(String namespaceURI, String sName, String qName)
	throws SAXException
	{
		if(qName.equals(currentElement))
		{
			Variable var = new Variable(currentElement,currentValue);
			vector.add(var);
		}
		else
		{
			Variable var = new Variable(qName,"");
			vector.add(var);
		}
	}
	public Hashtable<String, String> getHashTable()
	{
		for(int i=0; i < vector.size(); i++)
		{
			String hashKey;
			String hashVal = "";
			Variable var = (Variable)vector.elementAt(i);
			hashKey = var.getName();
			if (hashKey != null)
			{
				if (var.getValue()!= null)
				{
					hashVal = (String)var.getValue();
				}				
				this.htable.put(hashKey, hashVal);	
			}
		}
		return this.htable;
	}
	public Vector<Variable> getVector()
	{
		return this.vector;
	}
	public void print()
	{
		Enumeration<String> enumer = this.htable.keys();
		while(enumer.hasMoreElements())
		{
			Object o = enumer.nextElement();
//			System.out.println("Element/Attribute Name = "+ o.toString()+ " Value = "+ htable.get(o.toString()));
		}
	}
	
	public NodeList getNodes(String inputString, String tagName) {
		if (inputString == null || tagName == null) return null;
		
		NodeList nodeList = null;
		try
		{
			DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
			InputSource isrc = new InputSource();
			isrc.setCharacterStream(new StringReader(inputString));
			Document doc = domBuilder.parse(isrc);
			
			nodeList = doc.getElementsByTagName(tagName);
		}
		catch (Throwable e){}
		
		return nodeList;
	}

	public NodeList setParser(String inputString, String xPath) {
		if (selectNodeList == null) return null;
		
		NodeList nodelist = null;
		try
		{
			DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
			InputSource isrc = new InputSource();
			isrc.setCharacterStream(new StringReader(inputString));
			org.w3c.dom.Document doc=domBuilder.parse(isrc);
			
			NodeList tempnl = doc.getElementsByTagName("*");
			Node 	 node = null;
			if(tempnl != null){ node 	= tempnl.item(0);}
			
			if(node != null)
			{
				Object[] args = new Object[]{node, xPath};
				nodelist = (NodeList)selectNodeList.invoke(object, args);
			}
			return nodelist;
		}
		catch (Throwable e){e.printStackTrace(); return null;}
	}
	
	public String getXPath(org.w3c.dom.Node node, String xpath)	{
		if (selectSingleNode == null) return null; 
			
		String retstr = null;
		try
		{
			Object[] args = new Object[]{node, xpath};
			Node tempnode = (Node)selectSingleNode.invoke(object, args);
			if (tempnode !=null)
			{
				retstr = tempnode.getNodeValue();
			}
			return retstr;
		}
		catch(Exception e){e.printStackTrace();return retstr;}
        
	}

	public String getNodeValue(org.w3c.dom.Node node) {
		String retstr = null;
		try
		{
			if (node !=null & node.hasChildNodes())
			{
				retstr = node.getFirstChild().getNodeValue();
			}
			return retstr;
		}
		catch(Exception e){e.printStackTrace();return retstr;}
	}
	
	public String getAttribValue(org.w3c.dom.Node node, String attribName) {
		String retstr = null;
		try
		{
			//Object o  = xpathAPI.eval(node, xpath);
			if (node !=null)
			{
				NamedNodeMap  map = node.getAttributes();
				for(int i = 0; i < map.getLength(); i++)
				{	
					if (map.item(i).getNodeName().equals(attribName))
					{
						retstr = map.item(i).getNodeValue();
						break;
					}
				}
			}
			return retstr;
		}
		catch(Exception e){e.printStackTrace();return retstr;}
	}
	
	//Reflection util
	static void showMethods(Object o) {
	      Class c = o.getClass();
	      Method[] theMethods = c.getMethods();
	      for (int i = 0; i < theMethods.length; i++) {
	         String methodString = theMethods[i].getName();
	         System.out.println("Name: " + methodString);
	         String returnString =
	           theMethods[i].getReturnType().getName();
	         System.out.println("   Return Type: " + returnString);
	         Class[] parameterTypes = theMethods[i].getParameterTypes();
	         System.out.print("   Parameter Types:");
	         for (int k = 0; k < parameterTypes.length; k ++) {
	            String parameterString = parameterTypes[k].getName();
	            System.out.print(" " + parameterString);
	         }
	         
	      }
	}
}