/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitLaunchPlugin.java,v 1.2 2006/02/10 17:39:28 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.probekit.launch.internal.config.ProbekitLaunchMessages;
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;

import org.eclipse.jface.dialogs.ErrorDialog;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class ProbekitLaunchPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static ProbekitLaunchPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public ProbekitLaunchPlugin() {
		super();
		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static ProbekitLaunchPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= ProbekitLaunchPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		
		return getDefault().getResourceBundle();	// plugin.properties
	}
	
	public static String getPluginId() {
		
		return getDefault().getBundle().getSymbolicName();
	}

	public static int reportException(Throwable exception) {
		return reportException(exception, null, null);
	}
	
	public static int reportException(Throwable exception, String title, String message)
	{
		IStatus status = null;
		if (exception instanceof InvocationTargetException)
		{
			exception = ((InvocationTargetException) exception).getCause();
		}
		if (exception instanceof CoreException)
		{
			status = ((CoreException) exception).getStatus();
		}
		if (message == null && exception != null)
		{
			message = exception.getLocalizedMessage();
			if (message == null)
			{
				message = ProbekitLaunchMessages._2; //$NON-NLS-1$
			}
		}
		if (status == null && exception != null)
		{
			status = new Status(IStatus.ERROR, getPluginId(), IStatus.OK, exception.toString(), exception);
		}
		int dialogOkCancel = ErrorDialog.openError(getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()
				, ProbekitLaunchMessages._3, message, status);
		return dialogOkCancel;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		
		super.start(context);
		
		Runnable operation = new Runnable() {
			public void run() {
				try	{
					ProbekitLaunchImages.INSTANCE.initialize(new URL(getBundle().getEntry("/"), "icons/full/"), getImageRegistry());
				}
				catch(Exception e) {
				}		
			}
		};
		
		if (Display.getCurrent() == Display.getDefault()) {
			operation.run();
		}
		else {
			Display.getDefault().asyncExec(operation);
		}
		
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}
}
