/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbeFilterElementModifier.java,v 1.2 2006/02/10 17:39:28 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.config;

import org.eclipse.hyades.trace.ui.internal.util.FilterElementModifier;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Listener;

/**
 * @author gweidner
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ProbeFilterElementModifier extends FilterElementModifier {

	Listener _listener = null;
	
	/**
	 * @param viewer
	 */
	public ProbeFilterElementModifier(CheckboxTableViewer viewer, Listener listener) {
		super(viewer);
		// TODO Auto-generated constructor stub
		_listener = listener;
	}
	
	public void modify(Object element, String property, Object value)
	{
		try
		{
			if(element instanceof TableItem)
			{
				Object data = ((TableItem)element).getData();
				
				if(data != null && data instanceof FilterTableElement)
				{
					FilterTableElement e = (FilterTableElement)data;
	
					if (FilterTableElement.P_TEXT.equals(property))
					{
						if(value != null && !e.getText().equals(value.toString()))
						{
							//e.setText(value.toString());
							_listener.handleEvent(null);
						}
					}
					else if (FilterTableElement.P_METHOD.equals(property))
					{
						if(value != null && !e.getMethod().equals(value.toString()))
						{
							//e.setMethod(value.toString());
							_listener.handleEvent(null);
						}
					}
					
					else if (FilterTableElement.P_VISIBILITY.equals(property))
					{
						if(value != null && Integer.parseInt(value.toString()) != e.getVisibilityState())
						{
							//e.setVisibility(Integer.parseInt(value.toString()));
							_listener.handleEvent(null);
						}
					}				
				}	
			}
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
		
		super.modify(element, property, value);
	}
}
