/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbePropertiesUI.java,v 1.4 2006/07/18 18:35:46 nmehrega Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.config;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;

/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ProbePropertiesUI
{
	private Composite result;
	private Text _txtHint = null;
	private Color _colorLabel;
	private Group _grpProbeSet;
	private Label _lblName;
	private Text _txtName;
	private Label _lblID;
	private Text _txtID;
	private Label _lblVersion;
	private Text _txtVersion;
	private Label _lblPrefiltered;
	private Text _txtPrefiltered;
	private Label _lblImported;
	private Text _txtImported;
	private Label _lblLine;
	private Label _lblDescription;
	private Text _txtDescription;
	
	/**
	 * 
	 */
	public ProbePropertiesUI() {
		super();
	}
    
	public Composite createControl(Composite parent)
	{
		GridLayout layout;
		
		result = new Composite(parent, SWT.NONE);  

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;
	
		GridData data = new GridData(GridData.FILL_BOTH);
		data.heightHint = 300;
		data.widthHint = 400;  
	
		result.setLayout(layout);
		result.setLayoutData(data);
	
		createProperties();
		
		return result;
	}

	private void createProperties()
	{
		_grpProbeSet = new Group(result, SWT.NULL);
		GridData data = new GridData(GridData.FILL_BOTH);
		GridLayout layout = new GridLayout();
		data.widthHint = 300;  /* bugzilla 147057 */
		layout.numColumns = 4;
		_grpProbeSet.setLayout(layout);
		_grpProbeSet.setLayoutData(data);
		_grpProbeSet.setText(ProbekitLaunchMessages._10); //$NON-NLS-1$
		
		_lblName = new Label(_grpProbeSet, SWT.NONE);
		_lblName.setText(ProbekitLaunchMessages._11); //$NON-NLS-1$
		_colorLabel = _lblName.getBackground();
		data = new GridData();
		data.horizontalSpan = 1;
		_lblName.setLayoutData(data);
		_txtName = new Text(_grpProbeSet, SWT.READ_ONLY | SWT.LEFT /*| SWT.BORDER */);
		_txtName.setText(""); //$NON-NLS-1$
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 3;
		_txtName.setLayoutData(data);
		
		_lblPrefiltered = new Label(_grpProbeSet, SWT.RIGHT);
		_lblPrefiltered.setText(ProbekitLaunchMessages._12); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 1;
		_lblPrefiltered.setLayoutData(data);
		_lblPrefiltered.setAlignment(SWT.LEFT);
		_txtPrefiltered = new Text(_grpProbeSet, SWT.READ_ONLY | SWT.LEFT);
		_txtPrefiltered.setText(""); //$NON-NLS-1$
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 3;
		_txtPrefiltered.setLayoutData(data);
		
		_lblImported = new Label(_grpProbeSet, SWT.NONE);
		_lblImported.setText(ProbekitLaunchMessages._13); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 1;
		_lblImported.setLayoutData(data);
		_txtImported = new Text(_grpProbeSet, SWT.READ_ONLY | SWT.LEFT);
		_txtImported.setText(""); //$NON-NLS-1$
		data = new GridData(GridData.FILL_HORIZONTAL);
		//data.horizontalSpan = 1;
		data.horizontalSpan = 3;
		_txtImported.setLayoutData(data);
		
		_lblID = new Label(_grpProbeSet, SWT.NONE);
		_lblID.setText(ProbekitLaunchMessages._14); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 1;
		_lblID.setLayoutData(data);
		_txtID = new Text(_grpProbeSet, SWT.READ_ONLY | SWT.LEFT /*| SWT.BORDER */);
		_txtID.setText(""); //$NON-NLS-1$
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 3;
		_txtID.setLayoutData(data);

		_lblLine = new Label(_grpProbeSet, SWT.SEPARATOR | SWT.HORIZONTAL);
		//_lblLine = new Label(_grpProbeSet, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 4;
		data.grabExcessHorizontalSpace = true;
		_lblLine.setLayoutData(data);
		//_lblLine.setVisible(false);
		
		_lblVersion = new Label(_grpProbeSet, SWT.NONE);
		_lblVersion.setText(ProbekitLaunchMessages._15); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 1;
		_lblVersion.setLayoutData(data);
		_txtVersion = new Text(_grpProbeSet, SWT.READ_ONLY | SWT.LEFT /*| SWT.BORDER */);
		_txtVersion.setText(""); //$NON-NLS-1$
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 3;
		_txtVersion.setLayoutData(data);
		
		_lblDescription = new Label(_grpProbeSet, SWT.NONE);
		_lblDescription.setText(ProbekitLaunchMessages._16); //$NON-NLS-1$
		data = new GridData();
		data.horizontalSpan = 4;
		_lblDescription.setLayoutData(data);
		_txtDescription = new Text(_grpProbeSet, SWT.READ_ONLY | SWT.WRAP | SWT.MULTI | SWT.LEFT | SWT.V_SCROLL | SWT.BORDER);
		_txtDescription.setText(""); //$NON-NLS-1$
		data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 4;
		_txtDescription.setLayoutData(data);
		
		// Ensure that read-only Text controls have similar appearance to Label controls
		// (observed on Linux that read-only Text control had white background whereas
		// for Windows it had gray background just like static text Label control).
		_txtName.setBackground(_colorLabel);
		_txtPrefiltered.setBackground(_colorLabel);
		_txtImported.setBackground(_colorLabel);
		_txtID.setBackground(_colorLabel);
		_txtVersion.setBackground(_colorLabel);
		_txtDescription.setBackground(_colorLabel);
	}

	private void deleteProperties()
	{
		_lblName.dispose();
		_txtName.dispose();
		_lblID.dispose();
		_txtID.dispose();
		_lblVersion.dispose();
		_txtVersion.dispose();
		_lblPrefiltered.dispose();
		_txtPrefiltered.dispose();
		_lblImported.dispose();
		_txtImported.dispose();
		_lblLine.dispose();
		_lblDescription.dispose();
		_txtDescription.dispose();
		_grpProbeSet.dispose();
	}
	
	public void updateWidgetValues(ProbeRegistryEntry entry)
	{
		if (entry != null)
		{
			_txtName.setText(entry.getName());
			_txtID.setText(entry.getId());
			String vers = entry.getVersion();
			if (vers == null) vers = ""; //$NON-NLS-1$
			_txtVersion.setText(vers);
			String desc = entry.getDescription();
			if (desc == null) desc = ""; //$NON-NLS-1$
			_txtDescription.setText(desc);

			//TODO: possibly modify UI for filter set to be shown and indicate profiling, set-name, or built-in
			//TODO: (but leave this way for preferences - allow two different styles, one for launch, one for preferences)
			// Pre-filtered
			if (entry.hasTargets())
			{
				_txtPrefiltered.setText(ProbekitLaunchMessages._7); //$NON-NLS-1$
			}
			else
			{
				_txtPrefiltered.setText(ProbekitLaunchMessages._8); //$NON-NLS-1$
			}
			
			// Imported
			if (entry.isAuthored())
			{
				_txtImported.setText(ProbekitLaunchMessages._8); //$NON-NLS-1$
			}
			else
			{
				_txtImported.setText(ProbekitLaunchMessages._7); //$NON-NLS-1$
			}
			
		}
		else
		{
			_txtName.setText(""); //$NON-NLS-1$
			_txtID.setText(""); //$NON-NLS-1$
			_txtVersion.setText(""); //$NON-NLS-1$
			_txtDescription.setText(""); //$NON-NLS-1$
			_txtPrefiltered.setText(""); //$NON-NLS-1$
			_txtImported.setText(""); //$NON-NLS-1$
		}
	}
	
	public void showHint(boolean visible)
	{
		if (visible)
		{
			if (_txtHint == null)
			{
				deleteProperties();
				
				_txtHint = new Text(result, SWT.READ_ONLY | SWT.LEFT | SWT.WRAP);
				_txtHint.setText(ProbekitLaunchMessages._17); //$NON-NLS-1$
				_txtHint.setVisible(true);
				_txtHint.setBackground(_colorLabel);
				GridData data = new GridData(GridData.FILL_BOTH);
				_txtHint.setLayoutData(data);
			}
		}
		else
		{
			if (_txtHint != null)
			{
				_txtHint.dispose();
				_txtHint = null;
				
				createProperties();
			}
		}
		result.layout(true);
	}
}
