/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitProfilingType.java,v 1.20 2007/06/29 14:36:11 amehregani Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.probekit.ProbekitPlugin;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.ui.internal.AddProbeNatureOperation;
import org.eclipse.hyades.trace.ui.internal.launcher.IExtendedProfilingType;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.probekit.builder.ProbeNature;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchImages;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchUI;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * @author gweidner
 * @modified by ldancy
 * See also org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI.
 */
public class ProbekitProfilingType implements IExtendedProfilingType {
	
	/**
	 * Class variables necessary for keeping the IProfilingType
	 * interfcaes happy as well as for those IProfilingType
	 * methods we which to keep separate from the
	 * JVMTI implementation. The remainder of the old class variables have
	 * been moved to org.eclipse.tptp.platform.probekit.launch.ProbekitLaunchUI
	 * Liz Dancy; Enhancement 141540
	 */
	
	private Composite _form;

 	private ProbePropertiesUI _propertiesUI;

	private IDialogSettings _settings;

	private ProbekitLaunchUI probeUI;
	
	
	/* Navid Mehregani; Enhancement: 143251 */
	/* @see org.eclipse.hyades.trace.ui.internal.launcher.IExtendedProfilingType */
	public synchronized String getVMArguments(ILaunchConfiguration conf) 
	{
		
		/* Will hold the final VM argument */
		String vmArgument = "";
		
		/* Will hold the bootclasspath entry */
		String bootClassPath = "-Xbootclasspath/p:"; 
		
		/* Get the absolute path of the workspace */
		String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();	
		
		/* Logs informaiton messages if true. It can be set by using the following property: -DprobekitLogging=true */
		boolean log = Boolean.getBoolean("probekitLogging");
		
		/* If this is a Windows operating system, add quotes to the beginning and end of
		 * the value passed to bootclasspath.  This is done in case there are spaces in the
		 * path(s) specified. */
		if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1)
		{
			bootClassPath = bootClassPath + "\"";
		}
		
		/* Path separator ';' on Windows. ':' on Linux */
		String pathSeparator = System.getProperty("path.separator");
		
		/* Step through the project of each probe selected and add its CLASSPATH entries to
		 * the BOOTCLASSPATH
		 */
		Map activeProbes = getActiveProbes(conf);
		Iterator iterKeys = activeProbes.keySet().iterator();
		while (iterKeys.hasNext()) {
			String key = iterKeys.next().toString();
			String strProbeSpec = (String) activeProbes.get(key);
			ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString.fromString(strProbeSpec);
			String strProbeID = probeConfigDeploy.getRegistryId();
			ProbeRegistryEntry registryEntry = (ProbeRegistryEntry) probeUI.getRegistry().lookupById(strProbeID);
			IResource probeSource = null;			
			
			/* Extract the probe source file */
			try {
				probeSource = registryEntry.getSource();				
			} catch (InvalidProbeBundleException e) {
				IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._29, e);
				ProbekitPlugin.getDefault().getLog().log(status);
				continue; /* Error occured, skip to the next probe */
			}
			
			/* Make sure the probe source is not NULL */
			if (probeSource == null)
			{
				IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._30, null);
				ProbekitPlugin.getDefault().getLog().log(status);
				continue; /* Error occured, skip to the next probe */
			}

			/* Grab the Project where the probe resides */			
			IJavaProject javaProject = JavaCore.create(probeSource.getProject());
			if (javaProject != null)
			{
				String projectName = javaProject.getPath().toString();
				
				/* Log information messages if asked to */
				if (log)
				{
					/* Project Name */
					String message = NLS.bind(ProbekitLaunchMessages._36, projectName);
					IStatus status = new Status(IStatus.INFO, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
					ProbekitPlugin.getDefault().getLog().log(status);
					
					/* Probe Name */
					message = NLS.bind(ProbekitLaunchMessages._37, probeSource.toString());
					status = new Status(IStatus.INFO, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
					ProbekitPlugin.getDefault().getLog().log(status);
				}
				
				/* Bug 158019: For imported projects, 'workspaceLocation' has to be changed to refer to the real 
				 * workspace of the project.  Not the workspace that makes a reference to the real workspace. */
				String workspaceOfProbeFile = probeSource.getLocation().toString();
				if (workspaceOfProbeFile.indexOf(workspaceLocation) == -1)
				{
					workspaceLocation = workspaceOfProbeFile.substring(0, workspaceOfProbeFile.indexOf(projectName));
				}				
				/* End Bug 158019 */
				
				/* First add the output location of the project to BOOTCLASSPATH */
				try {										
					bootClassPath = bootClassPath + workspaceLocation + javaProject.getOutputLocation() + pathSeparator;
					
				} catch (JavaModelException e1) {
					IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._33, e1);
					ProbekitPlugin.getDefault().getLog().log(status);
				}				
				
				IClasspathEntry[] classpathEntryList; 
				try {
					/* Extract the classpath entry of the project */
					classpathEntryList = javaProject.getRawClasspath();
				} catch (JavaModelException e) {
					IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._31, e);
					ProbekitPlugin.getDefault().getLog().log(status);
					continue; /* Error occured, move on to the next probe */
				}
							
				/* Step through the classpath entries, check their type and properly add them to the BOOTCLASSPATH.
				 * There are five classpath entry types:
				 *  IClasspathEntry.CPE_SOURCE: Source folder of the project. Added as-is to the BOOTCLASSPATH
				 *  IClasspathEntry.CPE_LIBRARY: JAR library.  Added as-is to the BOOTCLASSPATH
				 *  IClasspathEntry.CPE_PROJECT: Project depends on another project in the workspace.  The 'bin'
				 *       directory of the project is added to BOOTCLASSPATH.
				 *  IClasspathEntry.CPE_VARIABLE: A classpath entry variable.  The variable is resolved and its
				 *       entry is added to BOOTCLASSPATH.
				 *  IClasspathEntry.CPE_CONTAINER: A classpath entry container. Containing source, library, and project
				 *       type entries. Container is resolved and its entries are added to BOOTCLASSPATH.  The standard
				 *       JRE container is ignored, since it's already in BOOTCLASSPATH.
				 */
				for (int i=0; i < classpathEntryList.length; i++)
				{
					/* Analyze one classpath entry at a time */
					IClasspathEntry classpathEntry = classpathEntryList[i];
					
					/* Get the classpath entry type */
					int type = classpathEntry.getEntryKind();
					
					String logMessage = "Type:";
					
					if (type == IClasspathEntry.CPE_SOURCE)
					{					
						if (classpathEntry.getPath().toString().startsWith(projectName))
							bootClassPath = bootClassPath + workspaceLocation;				
						
						bootClassPath = bootClassPath + classpathEntry.getPath().toString() + pathSeparator;
						logMessage = logMessage + "Source  Path:" + classpathEntry.getPath().toString();
					}
					else if (type == IClasspathEntry.CPE_LIBRARY)
					{											
						if (classpathEntry.getPath().toString().startsWith(projectName))
							bootClassPath = bootClassPath + workspaceLocation;				
						
						bootClassPath = bootClassPath + classpathEntry.getPath().toString() + pathSeparator;
						logMessage = logMessage + "Library  Path:" + classpathEntry.getPath().toString();
					}						
					else if (type == IClasspathEntry.CPE_PROJECT)
					{
						IProject dependentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(classpathEntry.getPath().toString().substring(1));
						IJavaProject dependentJavaProject = JavaCore.create(dependentProject.getProject());
						try {					
							bootClassPath = bootClassPath + workspaceLocation + dependentJavaProject.getOutputLocation().toString() + pathSeparator;
							logMessage = logMessage + "Project  Path:" + dependentJavaProject.getOutputLocation().toString();
						} catch (JavaModelException e) {
							IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._33, e);
							ProbekitPlugin.getDefault().getLog().log(status);
							continue; /* Error occured, move on to the next classpath entry */
						}						
					}
					else if (type == IClasspathEntry.CPE_VARIABLE)
					{
						if (classpathEntry.getPath().toString().startsWith(projectName))
							bootClassPath = bootClassPath + workspaceLocation;		
						
						bootClassPath = bootClassPath + JavaCore.getClasspathVariable(classpathEntry.getPath().toString()).toString() + pathSeparator;
						
						logMessage = logMessage + "Variable  Path:" + JavaCore.getClasspathVariable(classpathEntry.getPath().toString()).toString();
					}						
					else if (type == IClasspathEntry.CPE_CONTAINER)
					{					
						
						String logContainerContent = "";  /* Used for logging */						
						String containerName = classpathEntry.getPath().toString();
						
						/* Ignore if it's the JRE container.  It's already in the BOOTCLASSPATH */
						if (containerName.indexOf("JRE_CONTAINER") != -1)
						{
							logMessage = logMessage + "Container " + containerName + " is being ignored";							
						}
						else
						{
							IClasspathEntry[] containerContent;
							try
							{
								containerContent = JavaCore.getClasspathContainer(classpathEntry.getPath(), javaProject).getClasspathEntries();
							} catch (JavaModelException e) {
								IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._32, e);
								ProbekitPlugin.getDefault().getLog().log(status);
								continue; /* Error occured, skip to the next classpath entry */	
							}
							
							/* Step through the content of the container and add it to the BOOTCLASSPATH */
							for (int k=0; k < containerContent.length; k++)
							{
								classpathEntry = containerContent[k];
								type = classpathEntry.getEntryKind();
								
								if ((type == IClasspathEntry.CPE_SOURCE) || (type == IClasspathEntry.CPE_LIBRARY) || (type == IClasspathEntry.CPE_PROJECT))
								{									
									if (classpathEntry.getPath().toString().startsWith(projectName))
										bootClassPath = bootClassPath + workspaceLocation;	
									
									bootClassPath = bootClassPath + classpathEntry.getPath().toString() + pathSeparator;
									logContainerContent = logContainerContent + classpathEntry.getPath().toString() + pathSeparator;
								}
								else
								{
									String message = NLS.bind(ProbekitLaunchMessages._34, new Integer(type));
									IStatus status = new Status(IStatus.ERROR, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
									ProbekitPlugin.getDefault().getLog().log(status);
								}
							}
							logMessage = logMessage + "Container  Name:" + containerName + "  Path:" + logContainerContent;
							
						}
					} // end of else if	(type == IClasspathEntry.CPE_CONTAINER)		
							
					if (log)
					{
						IStatus status = new Status(IStatus.INFO, "org.eclipse.tptp.platform.probekit.launch", 0, logMessage, null);
						ProbekitPlugin.getDefault().getLog().log(status);
					}
					
				} // end of for loop
			} // end of if (javaProject != null)
		} // end of while loop

		/* If this is a Windows operating system, add quotes to the beginning and end of
		 * the value passed to bootclasspath.  This is done in case there are spaces in the
		 * path(s) specified. */
		if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1)
		{
			bootClassPath = bootClassPath + "\"";
		}
		
		/* Bugzilla 177010: We'll need to add another VM argument in order for OSGi to properly load our Probe
		 * classes from the boot classloader */
		String osgiProperty = "-Dorg.osgi.framework.bootdelegation=\"*\"";
		/* End of bugzilla 177010*/
		
		/* Are we logging information messages? */
		if (log)
		{
			String message = NLS.bind(ProbekitLaunchMessages._35, bootClassPath);
			IStatus status = new Status(IStatus.INFO, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
			ProbekitPlugin.getDefault().getLog().log(status);
		}		
		
		vmArgument = bootClassPath + " " + osgiProperty;
		
		return vmArgument;
	}

	/**
	 * 
	 */
	public ProbekitProfilingType() 
	{
		super();
		
		//_registry = ProbeRegistry.getRegistry();

		AbstractUIPlugin plugin = (AbstractUIPlugin) ProbekitLaunchPlugin
				.getDefault();
		IDialogSettings workbenchSettings = plugin.getDialogSettings();
		IDialogSettings section = workbenchSettings
				.getSection("ProbeLaunchDialog");//$NON-NLS-1$
		if (section == null) {
			section = workbenchSettings.addNewSection("ProbeLaunchDialog");//$NON-NLS-1$
		}
		_settings = section;
		
		probeUI = new ProbekitLaunchUI();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.trace.ui.launcher.IProfilingType#createControl(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy)
	 */
	public Control createControl(Composite parent, ProfilingSetsManagerCopy config) 
	{
		return probeUI.CreateControl(parent, config, true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.trace.ui.launcher.IProfilingType#getControl(java.lang.String)
	 */
	public Control getControl(String profilingSetName) {
		Table _tblProbeSets = probeUI.getProbeSets();
		if (_tblProbeSets.getItemCount() > 0) {
			int indexSelection = _tblProbeSets.getSelectionIndex();
			if (indexSelection < 0) {
				// Default to first item selected so properties not empty
				indexSelection = 0;
			}

			TableItem tableItem = _tblProbeSets.getItem(indexSelection);
			if (tableItem != null) {
				ProbeRegistryEntry entry = (ProbeRegistryEntry) tableItem
						.getData();
				if (entry != null) {
					_propertiesUI.updateWidgetValues(entry);
				}
			}
		}

		return _form;
	}

	protected void restoreSelections() {
		Table _tblProbeSets = probeUI.getProbeSets();
		String strSelection = ""; //$NON-NLS-1$
		String strTab = ""; //$NON-NLS-1$

		if (_settings != null) {
			strSelection = _settings.get("ProbeTableSelection"); //$NON-NLS-1$
			strTab = _settings.get("ProbeFolderSelection"); //$NON-NLS-1$
		}

		if (strSelection != null && strSelection.length() > 0) {
			int iNumProbeSets = _tblProbeSets.getItemCount();
			TableItem[] items = _tblProbeSets.getItems();

			for (int j = 0; j < iNumProbeSets; j++) {
				ProbeRegistryEntry entry = (ProbeRegistryEntry) items[j]
						.getData();
				if (entry != null) {
					String strEntryID = entry.getId();
					if (strEntryID.equals(strSelection)) {
						// Restore table selection
						_tblProbeSets.select(j);
					}
				}
			}
		} else {
			if (_tblProbeSets.getItemCount() > 0) {
				// Default to first item being selected so properties not empty
				_tblProbeSets.select(0);
			}
		}

		if (strTab != null && strTab.length() > 0) {
			if (strTab.equals(ProbekitLaunchMessages._19)) //$NON-NLS-1$
			{
				// TODO: disable due to repaint problems if initially selected
				// (also empty)
				// (ok if only explaination message shown)
				// /_folder.setSelection(1);
			}
			// else defaults to "Properties" in createControl()
		}
		// else defaults to "Properties" in createControl()
	}

	

	protected void initializeValues(ProfilingSetsManagerCopy config) {
		int iNumProbeSets = probeUI.getProbeSets().getItemCount();
		TableItem[] items = probeUI.getProbeSets().getItems();

		Map configAttributes = config.getDefaultSet().getAttributes();
		int index = 0;
		String strName = ProbeLaunchConfigString.LAUNCH_CONFIG_NAME_PREFIX
				+ probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + index;
		ProfilingAttribute attribute = (ProfilingAttribute) configAttributes
				.get(strName);
		// if (attribute != null)
		while (attribute != null) {
			String strValue = attribute.getValue();
			ProbeLaunchConfigString probeConfig = ProbeLaunchConfigString
					.fromString(strValue);
			// if (attribute != null)
			if (probeConfig != null) {
				// String strProbeKitID = attribute.getValue();
				String strProbeKitID = probeConfig.getRegistryId();
				for (int j = 0; j < iNumProbeSets; j++) {
					ProbeRegistryEntry entry = (ProbeRegistryEntry) items[j]
							.getData();
					if (entry != null) {
						String strEntryID = entry.getId();
						if (strEntryID.equals(strProbeKitID)) {
							items[j].setChecked(true);

							break;
						}
					}
				}
			}

			index++;

			strName = ProbeLaunchConfigString.LAUNCH_CONFIG_NAME_PREFIX
					+ probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + index;
			attribute = (ProfilingAttribute) configAttributes.get(strName);
			// }
		}
	}

	/**
	 * 
	 * @param launchConfig
	 * @return
	 */
	protected Map getActiveProbes(ILaunchConfiguration launchConfig) {
		String strProbeDeployPrefix = ProbeLaunchConfigString.AGENT_CONFIG_NAME_PREFIX
				+ probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX;
		Map map = getOptions(launchConfig, strProbeDeployPrefix);
		return map;
	}

	/**
	 * 
	 * @param launchConfig
	 * @param strPrefix
	 * @return
	 */
	protected Map getOptions(ILaunchConfiguration launchConfig, String strPrefix) {
		Map map = new HashMap();
		try {
			ProfilingSetsManager psm = ProfilingSetsManager.instance();
			Vector configOptions = psm.getOptions(launchConfig);
			Iterator iterOptions = configOptions.iterator();

			while (iterOptions.hasNext()) {
				AgentConfigurationEntry entry = (AgentConfigurationEntry) iterOptions
						.next();
				if (entry != null) {
					String strName = entry.getName();
					if ((strName != null) && strName.startsWith(strPrefix)) {
						String strValue = entry.getValue();
						map.put(strName, strValue);
					}
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}

		return map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.trace.ui.launcher.IProfilingType#getAttributes()
	 */

	public ProfilingAttribute[] getAttributes() {
		List config = new ArrayList();
		int iCheckedCount = 0;
		
		int iNumProbeSets = probeUI.getProbeSets().getItemCount();
		if (iNumProbeSets > 0) {
			TableItem[] items = probeUI.getProbeSets().getItems();
			for (int i = 0; i < iNumProbeSets; i++) {
				ProbeRegistryEntry entry = (ProbeRegistryEntry) items[i]
						.getData();
				if (entry != null) {
					String strValueID = entry.getId();

					ProbeLaunchConfigString probe = new ProbeLaunchConfigString();
					probe.addProbeID(strValueID);
					if (items[i].getChecked()) {
						// ProbeLaunchConfigString probe = new
						// ProbeLaunchConfigString();
						// probe.addProbeID(strValueID);
						//
						// /RATLC00379812 - Probekit launch UI needs to be
						// updated to support 2-tier filtering.
						// /if (!entry.hasTargets())
						// /{
						boolean bMatchingSetFound = false;
						FilterSetElement set = probeUI.getManager()
								.getDefaultFilterSet();

						// build filter string
						ArrayList attrs = null;
						StringBuffer filterStr = new StringBuffer();
						if (set != null) {
							attrs = set.getChildren();
							for (int idx = 0; idx < attrs.size(); idx++) {
								FilterTableElement elem = (FilterTableElement) attrs
										.get(idx);
								filterStr.append(elem.getText());
								if (elem.getMethod().length() > 0)
									filterStr
											.append(":").append(elem.getMethod()); //$NON-NLS-1$
								filterStr
										.append(":").append(elem.getVisibility()); //$NON-NLS-1$
								filterStr.append("&"); //$NON-NLS-1$
							}
						}

						if (bMatchingSetFound) {
							probe.addFilters(filterStr.toString());
						} else {
							// Filter set was deleted or renamed or set to null
							// to use profiling filters
							probe.useDefaultFilters();
						}
						// /}

						String strName = ProbeLaunchConfigString.LAUNCH_CONFIG_NAME_PREFIX
								+ probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX
								+ iCheckedCount;
						String strValueProbeLaunch = probe.toString();

						ProfilingAttribute attributeProbe = new ProfilingAttribute(
								strName, strValueProbeLaunch);
						config.add(attributeProbe);

						iCheckedCount++;
					}

				}
			}
		}

		// As a workaround to hyades bug of not removing attributes, write
		// number of checked probes
		// (but still a problem if uncheck probekit instrumentation since
		// settings still persist)
		ProfilingAttribute[] pOptions = new ProfilingAttribute[config.size()];
		config.toArray(pOptions);

		probeUI.saveSelections(iCheckedCount);

		return pOptions;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.trace.ui.launcher.IProfilingType#validateConfiguration(org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy)
	 */
	public String validateConfiguration(ProfilingSetsManagerCopy managerCopy) 
	{
		return probeUI.validateConfiguration(managerCopy);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.trace.ui.launcher.IProfilingType#launch(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public String launch(final ILaunchConfiguration config) {
		final ProfilingSetsManager psm = ProfilingSetsManager.instance();
		final ArrayList invalidProbes = new ArrayList();
		String strMissingOrInvalidProbes = ""; //$NON-NLS-1$
		String strLineSeparator = System.getProperty("line.separator"); //$NON-NLS-1$

		// RATLC00377606 - Removing a deployment component fails with no user
		// feedback
		try {
			Map mapProbeSpecs = getActiveProbes(config);

			Iterator iterKeys = mapProbeSpecs.keySet().iterator();
			while (iterKeys.hasNext()) {
				String key = iterKeys.next().toString();
				String strProbeSpec = (String) mapProbeSpecs.get(key);
				ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString
						.fromString(strProbeSpec);
				String strProbeID = probeConfigDeploy.getRegistryId();
				ProbeRegistryEntry entry = (ProbeRegistryEntry) probeUI.getRegistry()
						.lookupById(strProbeID);
				if (entry == null) {
					strMissingOrInvalidProbes = strMissingOrInvalidProbes
							+ strProbeID + strLineSeparator;
					invalidProbes.add(strProbeID);
				} else {
					try {
						entry.fullValidate();
					} catch (InvalidProbeBundleException e) {
						strMissingOrInvalidProbes = strMissingOrInvalidProbes
								+ strProbeID + strLineSeparator;
						invalidProbes.add(strProbeID);

						// Silently remove from registry so it will not show up
						// in subsequent lists, etc.
						probeUI.getRegistry().remove(entry);
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		if (strMissingOrInvalidProbes.length() > 0) {
			strMissingOrInvalidProbes = strLineSeparator
					+ strMissingOrInvalidProbes;
			final String strWarningQuery = NLS.bind(ProbekitLaunchMessages._26,
					strMissingOrInvalidProbes); //$NON-NLS-1$

			Display.getDefault().asyncExec(new Runnable() {
				public void run() {
					boolean bOK = MessageDialog.openQuestion(Display
							.getDefault().getActiveShell(),
							ProbekitLaunchMessages._27, strWarningQuery);
					if (bOK) {
						try {
							String setID = config
									.getAttribute(
											IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET,
											(String) null);
							IProfilingSet set = (IProfilingSet) psm
									.getProfilingSets().get(setID);
							if (set != null) {
								String strProbeOptionPrefix = ProbeLaunchConfigString.LAUNCH_CONFIG_NAME_PREFIX
										+ probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX;
								boolean bRemovedProbes = false;
								Map attributes = set.getAttributes();
								Iterator iterKeys = attributes.keySet()
										.iterator();

								while (iterKeys.hasNext()) {
									String key = iterKeys.next().toString();
									if (key.startsWith(strProbeOptionPrefix)) {
										ProfilingAttribute profAttribute = (ProfilingAttribute) attributes
												.get(key);
										String strValue = profAttribute
												.getValue();
										ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString
												.fromString(strValue);
										String strID = probeConfigDeploy
												.getRegistryId();
										// Check if invalid or missing probe
										if (invalidProbes.contains(strID)) {
											// Remove from attributes
											iterKeys.remove();
											bRemovedProbes = true;
										}
									}
								}
								// Update preferences to save profiling set
								// changes
								if (bRemovedProbes) {
									set.setAttributes(attributes);
									psm.writeSetsToPreferences();
								}
							}
						} catch (Exception e) {
							// TODO: Report more specific message indicating
							// removing probe from profiling set was not
							// successful
							e.printStackTrace();
							ProbekitLaunchPlugin.reportException(e);
						}
					}
				}
			});
		}

		return null;
	}

	
	
	

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.trace.ui.launcher.IProfilingType#getDescription()
	 */
	public String getDescription(ProfilingSetsManagerCopy config) {
		return probeUI.getDescription(config);
	}

	
}
