/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CustomWizardFileSystemResourceImportPage1.java,v 1.1 2006/03/16 15:56:15 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.io.File;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
//import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;

class CustomWizardFileSystemResourceImportPage1
	extends CustomWizardResourceImportPage
	/*implements Listener*/ {
	// widgets
	protected Combo sourceNameField;
	protected Button overwriteExistingResourcesCheckbox;
	protected Button sourceBrowseButton;
	//A boolean to indicate if the user has typed anything
	private boolean entryChanged = false;

	/**
	 *	Creates an instance of this class
	 */
	protected CustomWizardFileSystemResourceImportPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
		super(name,selection);
	}
	/** (non-Javadoc)
	 * Method declared on IDialogPage.
	 */
	public void createControl(Composite parent) {
		super.createControl(parent);
	}

	/**
	 *	Create the group for creating the root directory
	 */
	protected void createRootDirectoryGroup(Composite parent) {
		Composite sourceContainerGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		sourceContainerGroup.setLayout(layout);
		sourceContainerGroup.setLayoutData(
			new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
	
		Label groupLabel = new Label(sourceContainerGroup, SWT.NONE);
		groupLabel.setText(getSourceLabel());
	
		// source name entry field
		sourceNameField = new Combo(sourceContainerGroup, SWT.BORDER);
		sourceNameField.addListener(SWT.Modify, this);
		sourceNameField.addListener(SWT.Selection, this);
		GridData data =
			new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL);
		data.widthHint = SIZING_TEXT_FIELD_WIDTH;
		sourceNameField.setLayoutData(data);
	
		sourceNameField.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				updateFromSourceField();
			}
		});
		
		sourceNameField.addKeyListener(new KeyListener(){
			/*
			 * @see KeyListener.keyPressed
			 */
			public void keyPressed(KeyEvent e){
				//If there has been a key pressed then mark as dirty
				entryChanged = true;
			}
	
			/*
			 * @see KeyListener.keyReleased
			 */
			public void keyReleased(KeyEvent e){}
		});
		
		sourceNameField.addFocusListener(new FocusListener(){
			/*
			 * @see FocusListener.focusGained(FocusEvent)
			 */
			public void focusGained(FocusEvent e){
				//Do nothing when getting focus
			}
			
			/*
			 * @see FocusListener.focusLost(FocusEvent)
			 */
			public void focusLost(FocusEvent e){
				//Clear the flag to prevent constant update
				if(entryChanged){
					entryChanged = false;
					updateFromSourceField();
				}
				
			}	
		});
	
		// source browse button
		sourceBrowseButton = new Button(sourceContainerGroup, SWT.PUSH);
		sourceBrowseButton.setText(Messages.BrowseButton); //$NON-NLS-1$
		sourceBrowseButton.addListener(SWT.Selection, this);
		sourceBrowseButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		setButtonLayoutData(sourceBrowseButton);
	}
	
	/**
	 * Update the receiver from the source name field.
	 */
	private void updateFromSourceField(){
		setSourceName(sourceNameField.getText());
		//Update enablements when this is selected
		updateWidgetEnablements();
	}		
		
	/**
	 *	Create the import source specification widgets
	 */
	protected void createSourceGroup(Composite parent) {	
		createRootDirectoryGroup(parent);
	}
	
	/**
	 * Returns a File object representing the currently-named source directory iff
	 * it exists as a valid file, or <code>null</code> otherwise.
	 */
	protected File getSourceFile() {
		return getSourceFile(this.sourceNameField.getText());
	}
	
	/**
	 * Returns a File object representing the currently-named source directory iff
	 * it exists as a valid directory, or <code>null</code> otherwise.
	 *
	 * @param path a String not yet formatted for java.io.File compatability
	 */
	private File getSourceFile(String path) {
		File sourceFile = new File(path);
		if (!sourceFile.exists() || !sourceFile.isFile()) {
			return null;
		}
	
		return sourceFile;
	}
	
	/**
	 *	Answer the string to display as the label for the source specification field
	 */
	protected String getSourceLabel() {
		return ""; //$NON-NLS-1$
	}
	
	/**
	 * Sets the source name of the import to be the supplied path.
	 * Adds the name of the path to the list of items in the
	 * source combo and selects it.
	 *
	 * @param path the path to be added
	 */
	protected void setSourceName(String path) {	
		if (path.length() > 0) {
	
			String[] currentItems = this.sourceNameField.getItems();
			int selectionIndex = -1;
			for (int i = 0; i < currentItems.length; i++) {
				if (currentItems[i].equals(path))
					selectionIndex = i;
			}
			if (selectionIndex < 0) {
				int oldLength = currentItems.length;
				String[] newItems = new String[oldLength + 1];
				System.arraycopy(currentItems, 0, newItems, 0, oldLength);
				newItems[oldLength] = path;
				this.sourceNameField.setItems(newItems);
				selectionIndex = oldLength;
			}
			this.sourceNameField.select(selectionIndex);
		}
	}
	/* (non-Javadoc)
	 * Method declared on IDialogPage. Set the selection up when it becomes visible.
	 */
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible)
			this.sourceNameField.setFocus();
	}
	/**
	 * Check if widgets are enabled or disabled by a change in the dialog.
	 * Provided here to give access to inner classes.
	 * @param event Event
	 */
	protected void updateWidgetEnablements() {	
		super.updateWidgetEnablements();
	}
}
