/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CustomWizardResourceImportPage.java,v 1.1 2006/03/16 15:56:15 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
//import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
//import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

import org.eclipse.ui.dialogs.WizardDataTransferPage;

/**
 * The abstract superclass for a typical import wizard's main page.
 * <p>
 * Clients may subclass this page to inherit its common destination resource
 * selection facilities.
 * </p>
 * <p>
 * Subclasses must implement 
 * <ul>
 *   <li><code>createSourceGroup</code></li>
 * </ul>
 * </p>
 * <p>
 * Subclasses may override
 * <ul>
 *   <li><code>allowNewContainerName</code></li>
 * </ul>
 * </p>
 * <p>
 * Subclasses may extend
 * <ul>
 *   <li><code>handleEvent</code></li>
 * </ul>
 * </p>
 */
/**
 * See also org.eclipse.ui.dialogs.WizardResourceImportPage.
 */
public abstract class CustomWizardResourceImportPage extends WizardDataTransferPage {
	private IResource currentResourceSelection;

	// initial value stores

	// widgets

	//messages

	/**
	 * Creates an import wizard page. If the initial resource selection 
	 * contains exactly one container resource then it will be used as the default
	 * import destination.
	 *
	 * @param pageName the name of the page
	 * @param selection the current resource selection
	 */
	protected CustomWizardResourceImportPage(String name, IStructuredSelection selection) {
		super(name);
	
		//Initialize to null
		currentResourceSelection = null;
		if (selection.size() == 1){
			Object firstElement = selection.getFirstElement();
			if(firstElement instanceof IAdaptable){
				Object resource = ((IAdaptable) firstElement).getAdapter(IResource.class);
				if(resource != null)
					currentResourceSelection = (IResource) resource;
			}
		}		
	
		if (currentResourceSelection != null) {
			if ((currentResourceSelection.getType() != IResource.FILE) ||
				(!currentResourceSelection.isAccessible()))
			{
				currentResourceSelection = null;
			}
		}
	
	}
	/**
	 * The <code>WizardResourceImportPage</code> implementation of this 
	 * <code>WizardDataTransferPage</code> method returns <code>true</code>. 
	 * Subclasses may override this method.
	 */
	protected boolean allowNewContainerName() {
		return false;
	}
	/** (non-Javadoc)
	 * Method declared on IDialogPage.
	 */
	public void createControl(Composite parent) {
	
		initializeDialogUnits(parent);
		
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(
			GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
		composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	
		createSourceGroup(composite);
	
		createOptionsGroup(composite);
	
		restoreWidgetValues();
		updateWidgetEnablements();
		//setPageComplete(determinePageCompletion());	// redundant since done in updateWidgetEnablements
	
		setControl(composite);
	}
	/**
	 * Creates the import source specification controls.
	 * <p>
	 * Subclasses must implement this method.
	 * </p>
	 *
	 * @param parent the parent control
	 */
	protected abstract void createSourceGroup(Composite parent);
	
	/*
	 * @see WizardDataTransferPage.getErrorDialogTitle()
	 */
	protected String getErrorDialogTitle(){
		return Messages.IErrorDialogTitle; //$NON-NLS-1$
	}
	
	/**
	 * The <code>WizardResourceImportPage</code> implementation of this 
	 * <code>Listener</code> method handles all events and enablements for controls
	 * on this page. Subclasses may extend.
	 * @param event Event
	 */
	public void handleEvent(Event event) {
		updateWidgetEnablements();
	}
	/**
	 * Check if widgets are enabled or disabled by a change in the dialog.
	 * @param event Event
	 */
	protected void updateWidgetEnablements() {
	
		boolean pageComplete = determinePageCompletion();
		setPageComplete(pageComplete);
		if (pageComplete)
			setMessage(null);
		super.updateWidgetEnablements();
	}
	
	/*
	 * @see WizardDataTransferPage.determinePageCompletion.
	 */
	protected boolean determinePageCompletion() {
		return super.determinePageCompletion();
	}	
}
