/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ExportProbeWizard.java,v 1.2 2006/05/05 16:29:55 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import org.eclipse.jface.dialogs.IDialogSettings;

/**
 * @author gweidner
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ExportProbeWizard extends Wizard implements IExportWizard
{
	//protected ExportProbeWizardPage _page;
	protected ExportProbeWizardPage _page;
	protected IStructuredSelection _selection;
	protected IWorkbench _workbench;
	
	// dialog store id constant
	private final static String STORE_PROBE_EXPORT_SETTINGS_ID = "ProbeExportWizard"; //$NON-NLS-1$

	/**
	 * 
	 */
	public ExportProbeWizard()
	{
		super();
		
		AbstractUIPlugin plugin = (AbstractUIPlugin) ProbekitLaunchPlugin.getDefault();
		IDialogSettings workbenchSettings = plugin.getDialogSettings();
		IDialogSettings section = workbenchSettings.getSection(STORE_PROBE_EXPORT_SETTINGS_ID);
		if (section == null)
		{
			section = workbenchSettings.addNewSection(STORE_PROBE_EXPORT_SETTINGS_ID);
		}
		setDialogSettings(section);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		boolean bResult = _page.finish();
		return bResult;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		_workbench = workbench;
		_selection = selection;
		_page = new ExportProbeWizardPage(Messages.EPageName, selection); //$NON-NLS-1$
		
		setWindowTitle(Messages.EWindowTitle); //$NON-NLS-1$
//		setDefaultPageImageDescriptor(getImageDescriptor("icons/wizban/impprobekit_wizban.gif")); //$NON-NLS-1$
	}
	
	public void addPages()
	{
		super.addPages();
		addPage(_page);
	}
}
