/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProbekitUIHelpContextIDs.java,v 1.1 2006/03/16 15:56:15 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;

/**
 * @author gweidner
 *
 */
/**
 * Help context ids for Probekit User Interface.
 * <p>
 * This interface contains constants only; it is not intended to be implemented
 * or extended.
 * </p>
 * 
 */
interface IProbekitUIHelpContextIDs
{
	public static final String PROBEKIT_HELP_ID_PREFIX = ProbekitLaunchPlugin.getPluginId() + "."; //$NON-NLS-1$

	// Wizard pages
	public static final String EXPORT_PROBE_WIZARD_PAGE = PROBEKIT_HELP_ID_PREFIX + "pd_pk_wiz_export_probekit"; //$NON-NLS-1$
	public static final String IMPORT_PROBE_WIZARD_PAGE = PROBEKIT_HELP_ID_PREFIX + "pd_pk_wiz_import_probekit"; //$NON-NLS-1$
	public static final String CONVERT_PROBE_PROJECT_WIZARD_PAGE = PROBEKIT_HELP_ID_PREFIX + "pd_pk_dlg_convert_project"; //$NON-NLS-1$

	// Dialogs
	public static final String PROBEKIT_REGISTRY_PREFERENCE_PAGE = PROBEKIT_HELP_ID_PREFIX + "pd_pk_prefs_probekit_page"; //$NON-NLS-1$
	public static final String PROBEKIT_PROFILING_TYPE_EDIT_DIALOG = PROBEKIT_HELP_ID_PREFIX + "pd_pk_dlg_edit_profset_probekit_page"; //$NON-NLS-1$
}
