/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportProbeWizard.java,v 1.1 2006/03/16 15:56:15 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import java.util.List;

/**
 * @author gweidner
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ImportProbeWizard extends Wizard implements IImportWizard {
	private IWorkbench _workbench;
	private IStructuredSelection _selection;
	private ImportProbeWizardPage _mainPage;
	/**
	 * 
	 */
	public ImportProbeWizard() {
		super();
		AbstractUIPlugin plugin = (AbstractUIPlugin) ProbekitLaunchPlugin.getDefault();
		IDialogSettings workbenchSettings = plugin.getDialogSettings();
		IDialogSettings section = workbenchSettings.getSection("ProbeImportWizard"); //$NON-NLS-1$
		if (section == null)
			section = workbenchSettings.addNewSection("ProbeImportWizard"); //$NON-NLS-1$
		setDialogSettings(section);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		_workbench = workbench;
		_selection = currentSelection;
		
		List selectedResources = IDE.computeSelectedResources(currentSelection);
		if (!selectedResources.isEmpty()) {
			_selection = new StructuredSelection(selectedResources);
		}

		setWindowTitle(Messages.IWindowTitle); //$NON-NLS-1$
		//setDefaultPageImageDescriptor(getImageDescriptor("icons/wizban/impprobekit_wizban.gif")); //$NON-NLS-1$
		setNeedsProgressMonitor(true);
	}
	/* (non-Javadoc)
	 * Method declared on IWizard.
	 */
	public void addPages() {
		super.addPages();
		_mainPage = new ImportProbeWizardPage(_workbench, _selection);
		addPage(_mainPage);
	}
	/* (non-Javadoc)
	 * Method declared on IWizard.
	 */
	public boolean performCancel() {
		return _mainPage.cancel();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		return _mainPage.finish();
	}
}
