/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Messages.java,v 1.2 2008/03/22 18:16:55 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;


import org.eclipse.osgi.util.NLS;


public class Messages extends NLS{

	private static final String BUNDLE_NAME = "org.eclipse.tptp.platform.probekit.launch.internal.wizard.messages"; //$NON-NLS-1$

	private Messages() {
		// Do not instantiate
	}
	
	public static String InternalError;
	public static String BrowseButton;
	public static String QueryFileDialogTitle;//=Import Probe
	public static String IErrorDialogTitle;//=Import Probe Problems
	public static String ProbeRegistryException ;//= An internal error has occurred.  Unable to commit probe to the Probekit registry.
	public static String ErrorImporting ;//= Error importing ''{0}''.
	public static String FileMissingError ;//= One or more required files are missing.
	public static String ModelFileMissing ;//= Model file is missing.
	public static String ScriptFileMissing ;//= Probe script file is missing.
	public static String SupportFileMissing ;//= Support files (e.g., .class) are missing.
	public static String ModelFileInaccessible ;//= Unable to access model file.
	public static String ScriptFileInaccessible ;//= Unable to access probe script file.
	public static String SupportFileInaccessible ;//= Unable to access support files (e.g., .class).
	public static String FileInaccessibleError ;//= Unable to access one or more files.
	public static String InvalidModelError ;//= Unable to create Probekit model.
	public static String TooManyFiles ;//= Too many {0} files.
	public static String IPageName;//=ProbeImportPage1
	public static String IWindowTitle;//=Import
	public static String ISourceEmpty;//=Select a file containing a probe that is to be added to the Probekit registry.
	public static String PageTitle;//=Probe
	public static String OverwriteWarningCheckbox;//=&Overwrite existing probes without warning
	public static String WarningProbeExists;//=\tThe selected probe already exists in the workspace.
	public static String WarningOlderVersion;//=\tThe selected probe has an older version number.
	public static String WarningNewerVersion;//=\tThe selected probe has a newer version number.
	public static String WarningSameVersion;//=\tThe selected probe has the same version number.
	public static String WarningVersionConflict;//=The selected probe conflicts with an existing probe already registered in the Probekit registry under the same ID.  Additional details are as follows.
	public static String WarningOverwriteConfirm;//=Overwrite existing probe with selected probe?
	public static String WarningTitle;//=Import Probe
	public static String SourceLabel;//=From &file:

	public static String Description;//=Export a probe to the local file system.
	public static String DestinationLabel;//=To &file:
	public static String ToDirectory ;//= To director&y:
	public static String DestinationBrowseButton;//=B&rowse...
	public static String ProjectsTreeLabel ;//= Probekit projects:
	public static String FilesListLabel ;//= Probe files:
	public static String FileDialogText;//=Export Probe
	public static String IncludeSourceCheckbox;//=&Include probe source file
	public static String RootName ;//= workspace root
	public static String EPageName;//=Probe
	public static String EWindowTitle;//=Export
	public static String ExportingTitle ;//= Exporting:
	public static String InformationDialogTitle;//=Information
	public static String ProblemsExporting ;//= Problems were encountered during export:
	public static String ErrorDialogTitle;//=Export Probe Problems
	public static String ErrorExporting ;//= Error exporting {0}: {1}
	public static String SourceInvalid ;//= Selected probe is not a valid resource file.
	public static String SourceEmpty;//=Select a probe to be exported.
	public static String DestinationEmpty;//=Please enter a destination for the exported probe.
	public static String MustBeFile;//=Export destination must be a file, not a directory.
	public static String AlreadyExists ;//= Target file already exists.  Would you like to overwrite it?
	public static String AlreadyExistsError ;//= Export destination already exists and cannot be overwritten.
	public static String InvalidExtension ;//= Export destination file name must end with '.probekit'.
	public static String NoneSelected ;//= There are no resources currently selected for public static String 
	public static String CannotOpen ;//= Unable to open destination file: {0}
	public static String CannotClose ;//= Unable to close destination file: {0}
	public static String CreateTargetDirectory ;//= Target directory does not exist.  Would you like to create it?
	public static String DirectoryCreationError ;//= Target directory could not be created.
	public static String DirectoryExists ;//= Target directory already exists as a file.
	public static String ConflictingContainer ;//= Destination directory conflicts with location of {0}.
	public static String InvalidProbeSourceError ;//= Invalid probe source file ''{0}''.
	public static String PropertyUnavailableError ;//= Persistent property not available.
	public static String MissingResourceError ;//= Required resource ''{0}'' is missing or not accessible.
	public static String GeneralResourceError ;//= One or more build-generated files are missing for ''{0}''.
	public static String BuildRequiredError ;//= Unable to export ''{0}''.
	public static String RebuildProjectHint ;//= Rebuild the project ''{0}''.
	
	static {
		NLS.initializeMessages(BUNDLE_NAME, Messages.class);
	}
}
