/********************************************************************** 
 * Copyright (c) 2004, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: LaunchPadExtensionSlot.java,v 1.3 2007/06/05 19:59:31 amehregani Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

/**
 * LaunchPad Extension Slot for the Probe Kit
 * This class implements an extension point for Hyades process launcher.
 * It takes over the handlePreAgentActive notification.
 * At this point the Launch configuration must be populated by the probe
 * specific entries. If any such entries are found the appropriate information
 * is delivered to the Agent through the RAC. 
 * 
 * Created on Apr 8, 2004
 *
 */
package org.eclipse.tptp.platform.probekit.launch.launchpad;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.launcher.ILauncherHandler;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;


/**
 * This class serves as the Extension Slot for both the JVMPI and
 * JVMTI Probekits. It acts as the liaison between the client side
 * code and the probekit agent extension in both cases. Each respective
 * Probekit will call their version of handlePreAgentActive in order to
 * create a LaunchPad to deploy user-selected probes.
 * 
 * @author vhavin
 * @modified by Liz Dancy
 */
public class LaunchPadExtensionSlot implements ILauncherHandler  {

	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.launcher.ILauncherHandler#handleProcessLaunched(org.eclipse.hyades.models.hierarchy.TRCProcessProxy)
	 */
	public void handleProcessLaunched(TRCProcessProxy processProxy) {
		// Not used
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.launcher.ILauncherHandler#handleProcessExited(org.eclipse.hyades.models.hierarchy.TRCProcessProxy)
	 */
	public void handleProcessExited(TRCProcessProxy processProxy) {
		// Not used
	}

	/** 
	 * 
	 * 	 
	 * Gets called by the execution framework before the 
	 * agentActive notification gets processed (see IAgentListener)
	 * 
	 * This is the right place to send commands that should be processed
	 * while the agent is held inside dllOnLoad processing.
	 * Note that agent should be started in the 'controlled' mode.
	 * @param agentProxy - Agent Proxy 
	 *   
	 */
	public void handlePreAgentActive(TRCAgentProxy agentProxy) 
	{
		try
		{
			LaunchPad launchPad = new LaunchPad();
			launchPad.agentActive(agentProxy);
		}
		catch(Exception e)
		{
			//TODO: Implement the real exception processing
		}
	}

	/**
	 * In the case of the JVMTI Agent we pass in the
	 * entire agent. This method overload is due to the different command
	 * formats in the old and new execution frameworks
	 * requiring different flows of control through the
	 * LaunchPad.
	 * 
	 * Created April, 2007
	 * @param agent - the active Agent
	 * @param config - the LaunchConfiguration
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public void handlePreAgentActiveJVMTI(IAgent agent, ILaunchConfiguration config)throws CoreException, LaunchPadException
	{
			LaunchPadJVMTI launchPad = new LaunchPadJVMTI();
			launchPad.agentActive((ICollector)agent, config);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.launcher.ILauncherHandler#handlePostAgentActive(org.eclipse.hyades.models.hierarchy.TRCAgentProxy)
	 */
	public void handlePostAgentActive(TRCAgentProxy agentProxy) {
		// Not used
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.trace.ui.launcher.ILauncherHandler#handleAgentInactive(org.eclipse.hyades.models.hierarchy.TRCAgentProxy)
	 */
	public void handleAgentInactive(TRCAgentProxy agentProxy) {
		// Not used
	}
	
}
