/********************************************************************** 
 * Copyright (c) 2004, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * 
 * Contributors: 
 * IBM and OCSystems- Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.launch.launchpad;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.eclipse.tptp.platform.probekit.util.ProbekitConstants;
import org.eclipse.tptp.platform.probekit.util.ProbekitDebugConfig;

/**
 * A Utility class for the shared methods applicable to both the
 * JVMPI and JVMTI implementations of the probekit
 * Launch Pads.
 * @author Liz Dancy 
 * @see org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPad#
 *
 */
 class LaunchPadUtils 
{

	/**
	 * A simple tracing method to print errors
	 * @param message The Message to trace
	 * @see org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPad#trace(String)
	 */
	static void trace(String message)
	{
		if ( ProbekitDebugConfig.TRACE_LAUNCHPAD && message != null &&
				message.length() > 0) {
			System.out.println("ProbeLaunchPad: " + message);
		}
	}
	
	/**
	 * A simple helper method to determine whether the file in question is
	 * a class file. We use this as a filter to make sure we only deploy the
	 * .class probe files
	 * @param file The given file
	 * @return - true if the file is a class file and false otherwise
	 * @see org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPad#isClass(File)
	 */
	static boolean isClass(File file) 
	{
		if(file.getName().endsWith(ProbekitConstants.CLASS_FILE_EXT))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * Read bytes from the input file into the array of bytes.
	 * 
	 * @param file the input file 
	 * @return - array of bytes from the file (no conversion applied)
	 * @throws FileNotFoundException
	 * @throws IOException
	 * @see org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPad#readFileIntoBuffer(File)
	 */
	static byte[] readFileIntoBuffer(File file) throws FileNotFoundException, IOException
	{
		FileInputStream fs;
		byte buffer[];
		
		fs = new FileInputStream(file);
		DataInputStream probeStream = new DataInputStream(fs);
		try {
			int bufferSize = (int)file.length();
			buffer = new byte[bufferSize];
			probeStream.read(buffer);
		} finally {
			probeStream.close();
		}
		return buffer;
	}
	

	
}// end class
