/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: AllocationSite.java,v 1.2 2007/03/16 14:37:45 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client;

import org.eclipse.hyades.models.trace.TRCMethod;

public class AllocationSite {

	public int _lineNo;
	public int _total;
	public int _sumAges;
	public int _collected;
	public int _totalSize;
	public int _collectedSize;
	public TRCMethod _method;

	public AllocationSite() {
	}

	public AllocationSite(int lineNo, TRCMethod method) {
		_method = method;
		_lineNo = lineNo;
	}

	public String getPackageName() {
		String name = null;
		if (_method != null && _method.getDefiningClass() != null
				&& _method.getDefiningClass().getPackage() != null) {
			name = _method.getDefiningClass().getPackage().getName();
		}
		return name;
	}

	public String getClassName() {
		String name = null;
		if (_method != null && _method.getDefiningClass() != null) {
			name = _method.getDefiningClass().getName();
		}
		return name;
	}

	public String getMethodName() {
		String name = null;
		if (_method != null) {
			name = _method.getName();
		}
		return name;
	}

	public void clear() {
		_lineNo = 0;
		_total = 0;
		_sumAges = 0;
		_collected = 0;
		_totalSize = 0;
		_collectedSize = 0;
		_method = null;
	}

	public void sumOf(final AllocationSite a) {
		_total += a._total;
		_sumAges += a._sumAges;
		_collected += a._collected;
		_totalSize += a._totalSize;
		_collectedSize += a._collectedSize;
	}
}
