/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: AverageAgeLP.java,v 1.2 2007/03/01 17:53:15 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.context;

import java.util.List;

import org.eclipse.hyades.trace.views.internal.context.java.formatters.AttrLPAdapter;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

import com.ibm.icu.text.NumberFormat;

public class AverageAgeLP extends AttrLPAdapter {

	static NumberFormat _decimalFormat = null;

	public static String formatValue(double d) {
		if (_decimalFormat == null) {
			_decimalFormat = NumberFormat.getNumberInstance();
			_decimalFormat.setMaximumFractionDigits(2);
			_decimalFormat.setMinimumFractionDigits(0);
		}
		return _decimalFormat.format(d);
	}

	public String getDisplayStringFromElement(Object value, Object element,
			int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return UIMessages._AVG_AGE;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT) {
			if (value != null && value instanceof Integer)
				return value.toString();
			if (value != null && value instanceof Double) {
				return formatValue(((Double) value).doubleValue());
			}
		}
		return "";
	}

	protected List internalSupportModes() {
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		return modes;
	}
}
