/*****************************************************************************
 * Copyright (c) 2007, 2010 Intel Corporation and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: TIContextProvider.java,v 1.5 2010/12/21 21:41:22 mreid Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.hyades.trace.views.internal.context.java.BasicContextProvider;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.AttrLPAdapter;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.CustomColumn;

public class TIContextProvider extends BasicContextProvider implements TIContextAttributes {

	private Map _contextLabelFormatProviders;
	private ArrayList _supportAttributes;
	static private TIContextProvider _instance;

	private Map<String,AttrLPAdapter> _customAttributes;
	
	static public TIContextProvider instance() {
		if (null == _instance)
			_instance = new TIContextProvider();
		return _instance;
	}

	public TIContextProvider() {
		_instance = this;
		_contextLabelFormatProviders = new HashMap();
		_supportAttributes = new ArrayList();
		_supportAttributes.add(METHOD_LINE_NUMBER);
		_supportAttributes.add(PACKAGE_AVG_AGE);
		_supportAttributes.add(PACKAGE_GENERATIONS);
		_supportAttributes.add(CLASS_AVG_AGE);
		_supportAttributes.add(CLASS_GENERATIONS);
		_supportAttributes.add(CALL_SITE_AVG_AGE);
		_supportAttributes.add(CALL_SITE_GENERATIONS);
		_supportAttributes.add(THREAD_NAME);
		_supportAttributes.add(THREAD_CLASS_NAME);
		_supportAttributes.add(THREAD_START_TIME);
		_supportAttributes.add(THREAD_STOP_TIME);
		_supportAttributes.add(THREAD_STATE);
		_supportAttributes.add(THREAD_RUNNING_TIME);
		_supportAttributes.add(THREAD_SLEEPING_TIME);
		_supportAttributes.add(THREAD_WAITING_TIME);
		_supportAttributes.add(THREAD_BLOCKED_TIME);
		_supportAttributes.add(THREAD_DEADLOCKED_TIME);
		_supportAttributes.add(THREAD_BLOCK_COUNT);
		_supportAttributes.add(THREAD_DEADLOCK_COUNT);

		// Add custom column attributes
		_customAttributes = new HashMap<String,AttrLPAdapter>();
		for( CustomColumn customColumn : CustomColumn.getContributors() )		
			_customAttributes.put( customColumn.getId(), customColumn.getAttrAdapter() );
	}

	public String getBaseProvider() {
		//return "org.eclipse.hyades.trace.views.internal.context.java.BasicContextProvider";
		return null;
	}

	public IContextLabelFormatProvider getContextLabelFormatProvider(String key) {
		IContextLabelFormatProvider result = (IContextLabelFormatProvider) _contextLabelFormatProviders.get(key);
		if (result != null) {
			return result;
		} else if (_supportAttributes.contains(key)) {
			if (key.equals(METHOD_LINE_NUMBER))
				result = new LineNumberLP();
			else if (key.equals(PACKAGE_AVG_AGE) || key.equals(CLASS_AVG_AGE) || key.equals(CALL_SITE_AVG_AGE))
				result = new AverageAgeLP();
			else if (key.equals(PACKAGE_GENERATIONS) || key.equals(CLASS_GENERATIONS) || key.equals(CALL_SITE_GENERATIONS))
				result = new GenerationsLP();
			else if (key.equals(THREAD_NAME))
				result = new ThreadNameLP();
			else if (key.equals(THREAD_CLASS_NAME))
				result = new ThreadClassNameLP();
			else if (key.equals(THREAD_START_TIME))
				result = new ThreadStartTimeLP();
			else if (key.equals(THREAD_STOP_TIME))
				result = new ThreadStopTimeLP();
			else if (key.equals(THREAD_STATE))
				result = new ThreadStateLP();
			else if (key.equals(THREAD_RUNNING_TIME))
				result = new ThreadRunningTimeLP();
			else if (key.equals(THREAD_SLEEPING_TIME))
				result = new ThreadSleepingTimeLP();
			else if (key.equals(THREAD_WAITING_TIME))
				result = new ThreadWaitingTimeLP();
			else if (key.equals(THREAD_BLOCKED_TIME))
				result = new ThreadBlockedTimeLP();
			else if (key.equals(THREAD_DEADLOCKED_TIME))
				result = new ThreadDeadlockedTimeLP();
			else if (key.equals(THREAD_BLOCK_COUNT))
				result = new ThreadBlockCountLP();
			else if (key.equals(THREAD_DEADLOCK_COUNT))
				result = new ThreadDeadlockCountLP();
		} else if ( _customAttributes.containsKey(key) ) {
			result = _customAttributes.get(key);
		} else {
			result = super.getContextLabelFormatProvider(key);
		}
		if (result != null) {
			_contextLabelFormatProviders.put(key, result);
		}
		return result;
	}

	public String getDescription() {
		return null;
	}

	public String getName() {
		return UIMessages.TI_CONTEXT_PROVIDER;
	}

	public String[] getSupportAttributes() {
		String[] supportAttributes0 = super.getSupportAttributes();
		String[] supportAttributes = new String[supportAttributes0.length + _supportAttributes.size()];
		System.arraycopy(supportAttributes0, 0, supportAttributes, 0, supportAttributes0.length);
		for (int i = supportAttributes0.length; i < supportAttributes.length; i++) {
			supportAttributes[i] = (String) _supportAttributes.get(i - supportAttributes0.length);
		}
		return supportAttributes;
	}
}
