/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: TIContextUpdaterHelper.java,v 1.1 2007/02/27 18:37:34 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.context;

import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;

public class TIContextUpdaterHelper extends ContextUpdaterHelper {

	public static ColumnDisplayInfo updateAverageAge(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalAge)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalAge;
		return info;
	}

	public static ColumnDisplayInfo updateGenerations(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalGenerations)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalGenerations;
		return info;
	}
}
