/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: ThreadWaitingTimeLP.java,v 1.1 2007/02/27 18:37:34 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.context;

import java.util.List;

import org.eclipse.hyades.trace.views.internal.context.java.formatters.AttrLPAdapter;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadWaitingTimeLP extends AttrLPAdapter {

	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return UIMessages._THREAD_WAITING_TIME;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT) {
			if (value != null && value instanceof Double)
				return Utils.formatTime(((Double)value).doubleValue());
		}
		return null;
	}

	protected List internalSupportModes() {
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		return modes;
	}
}
