/*****************************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: BaseProfilerView.java,v 1.1 2007/04/20 13:06:48 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class BaseProfilerView implements IViewSelectionChangedListener {
	static public Object _empty[] = new Object[0];
	static public String PREFERENCE_KEY_PREFIX = "org.eclipse.tptp.trace.jvmti.internal.client.views.";

	protected Composite _viewContainer;
	protected Composite _viewComp;
	protected HyadesFormToolkit _toolkit;
	protected TraceViewerPage _page;

	abstract protected Control createDataViewer(Composite parent);
	abstract protected String getViewTypeStr();
	abstract protected void update();

	protected BaseProfilerView(Composite parent, TraceViewerPage page) {
		_page = page;
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, getContextHelpId());
		createControl(parent);
	}

	int getMarginWidth(int idx) {
		return idx == 0 ? 5 : 0;
	}

	int getMarginHeight(int idx) {
		return idx == 0 ? 5 : 0;
	}

	protected Composite createControl(Composite parent) {
		_toolkit = new HyadesFormToolkit(parent.getDisplay());
		GridLayout layout;
		_viewContainer = _toolkit.createComposite(parent, SWT.FLAT);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.marginWidth = getMarginWidth(0);
		layout.marginHeight = getMarginHeight(0);
		_viewContainer.setLayout(layout);
		_viewContainer.setLayoutData(GridUtil.createFill());
		createLabel(_viewContainer);
		_viewComp = _toolkit.createComposite(_viewContainer, SWT.FLAT);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.marginWidth = getMarginWidth(1);
		layout.marginHeight = getMarginWidth(1);
		_viewComp.setLayout(layout);
		_viewComp.setLayoutData(GridUtil.createFill());
		Control dataView = createDataViewer(_viewComp);
		dataView.setLayoutData(GridUtil.createFill());
		return _viewContainer;
	}
	
	public void dispose() {
	}

	protected String getPreferenceString(String str) {
		return getViewTypeStr() + "." + str;
	}

	protected void createLabel(Composite viewContainer) {
	}

	public HyadesFormToolkit getToolkit() {
		return _toolkit;
	}

	public Control getControl() {
		return _viewContainer;
	}

	protected Composite getViewComponent() {
		return _viewComp;
	}

	protected String getContextHelpId() {
		return null;
	}

	public ISelection getSelection() {
		return null;
	}

	public void updateModelSelection() {
		ISelection selection = getSelection();
		Object sel = null;
		if (selection != null && !selection.isEmpty()) {
			sel = ((IStructuredSelection) selection).getFirstElement();
		}
		notifyViewSelectionChanged(this, sel);
	}

	public void notifyViewSelectionChanged(Object source, Object selection) {
		if (null != selection)
			UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).add(selection);
		ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
		event.setSource(source);
		UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
	}

	protected Object getSelectionModel() {
		ITraceSelection model = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
		Object sel = null;
		if (model != null && model.size() > 0) {
			sel = model.getFirstElement();
		}
		return sel;
	}

	public void selectionChanged() {
		handleSelectionEvent();
	}

	protected void handleSelectionEvent() {
		Object sel = getSelectionModel();
		if (sel != null)
			select(sel);
	}

	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
		Object source = event.getSource();
		if (source != this) {
			handleSelectionEvent();
		} else {
			updateButtons();
		}
	}

	void updateButtons() {
	}

	protected void select(Object obj) {
	}
	
	public void menuAboutToShow(IMenuManager arg0) {
	}
}
