/**********************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: MonitorClassDetails.java,v 1.1 2008/03/12 16:54:03 aalexeev Exp $
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Alexander  N. Alexeev, Intel - Initial API and implementation
 **********************************************************************/  

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.HashMap;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;

public class MonitorClassDetails {

	protected HashMap _monWaitCallSites = new HashMap();
	protected HashMap _monBlockCallSites = new HashMap();
	
	protected TRCClass _monClass;
		
	protected double _blockTime;
	protected int _blockCount;
	protected double _waitTime;
	protected int _waitCount;
	
	MonitorClassDetails(TRCClass monClass) {
		this._monClass = monClass;
	}
	
	public int getWaitingCount() {
		return _waitCount;
	}

	public int getBlockedCount() {
		return _blockCount;
	}

	public TRCClass getClassObj() {
		return _monClass;
	}
	
	public double getBlockedTime() {
		return _blockTime;
	}
	
	public double getWaitingTime () {
		return _waitTime;
	}

	public void updateMonitorsData(TRCThreadEvent event, double timeSpan) {
		if(event instanceof TRCThreadWaitingForObjectEvent) {
			_waitCount++;
			_waitTime += timeSpan;		
			MonitorCallDetails callSite = new MonitorCallDetails(event);
			if (!_monWaitCallSites.containsKey(callSite)) {
				_monWaitCallSites.put(callSite, callSite);
			} else {
				callSite = (MonitorCallDetails)_monWaitCallSites.get(callSite);
			}
			callSite.updateCallData(event, timeSpan);
		} else if(event instanceof TRCThreadWaitingForLockEvent) {
			_blockCount++;
			_blockTime += timeSpan;		
			MonitorCallDetails callSite = new MonitorCallDetails(event);
			if (!_monBlockCallSites.containsKey(callSite)) {
				_monBlockCallSites.put(callSite, callSite);
			} else {
				callSite = (MonitorCallDetails)_monBlockCallSites.get(callSite);
			}
			callSite.updateCallData(event, timeSpan);
		}
	}
	
	public Object[] getWaitCalls() {
		return _monWaitCallSites.values().toArray();
	}

	public Object[] getBlockCalls() {
		return _monBlockCallSites.values().toArray();
	}

}
