/**********************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: MonitorClassWaitingStatistics.java,v 1.2 2008/04/14 11:22:28 aalexeev Exp $
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Alexander  N. Alexeev, Intel - Initial API and implementation
 **********************************************************************/  

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.MonitorCallStackToolTipCreater;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Section;

public class MonitorClassWaitingStatistics  extends LabelProvider implements ITableLabelProvider, SelectionListener{

	private final static int MONSTAT_WAITTIME_COL_CALLER_NUM = 0;
	private final static int MONSTAT_WAITTIME_COL_CALLER_DEFW = 250;
	private final static int MONSTAT_WAITTIME_COL_TOTAL_TIME_NUM = 1;
	private final static int MONSTAT_WAITTIME_COL_TOTAL_TIME_DEFW = 100;
	private final static int MONSTAT_WAITTIME_COL_COUNT_NUM = 2;
	private final static int MONSTAT_WAITTIME_COL_COUNT_DEFW = 100;
	private final static int MONSTAT_WAITTIME_COL_STAT_NUM = 3;
	private final static int MONSTAT_WAITTIME_COL_STAT_DEFW = 200;
	private final static int MONSTAT_WAITTIME_COL_OBJECT_NUM_NUM = 4;
	private final static int MONSTAT_WAITTIME_COL_OBJECT_NUM_DEFW = 100;
	private final static int MONSTAT_WAITTIME_COL_THREAD_NUM_NUM = 5;
	private final static int MONSTAT_WAITTIME_COL_THREAD_NUM_DEFW = 100;
	
	//overall column number
	private final static int MONSTAT_WAITTIME_COL_NUM = 6;
	
	protected Composite _viewContainer;
	protected ViewForm _dataPane;
	protected StructuredViewer _viewer;
	protected Layout _layout = null;
	MonitorWaitingStatisticsSorter _sorter;
	
	protected HyadesFormToolkit _toolkit;
	
	MonitorStatisticController monViewCtrl;
	
	
	public MonitorClassWaitingStatistics(Section section, MonitorStatisticController monViewCtrl) {
		this.monViewCtrl = monViewCtrl;
		_toolkit = new HyadesFormToolkit(section.getDisplay());		
		_dataPane = _toolkit.createViewForm(section);
		_viewContainer = _dataPane;
		Control table = createTableViewer(_dataPane);
		_dataPane.setContent(table);	
	}
	
	public Layout getLayout() {
		if (_layout == null)
		{
			_layout = new ColumnLayout();
			((ColumnLayout)_layout).maxNumColumns = 100;
		}
		return _layout;
	}		
	
	private Control createTableViewer(ViewForm parent) {
		Tree tree = _toolkit.createTree(parent, SWT.MULTI | SWT.FULL_SELECTION | SWT.FLAT);
		
		tree.setLinesVisible(true);
		tree.setHeaderVisible(true);
		tree.setLayout(getLayout());
		tree.setLayoutData(new GridData(GridData.FILL_BOTH));
		tree.addSelectionListener(this);
		MonitorCallStackToolTipCreater.createStackTraceToolTip(tree);
		
		_viewer = new TreeViewer(tree);
		_viewer.setContentProvider(getContentProvider());
		_viewer.setLabelProvider(getTableLabelProvider());
		_sorter = new MonitorWaitingStatisticsSorter();
		_viewer.setSorter(_sorter);
				
		createColumns(tree);		
		_sorter.changeColumnSelection(0);
		
		monViewCtrl.setWaitTimeViewer(_viewer);
		return _viewer.getControl();
	}

	private void createColumns(Tree tree) {

		int colWidth[] = new int[MONSTAT_WAITTIME_COL_NUM];
		String colTitle[] = new String[MONSTAT_WAITTIME_COL_NUM];
		TreeColumn columns[] = new TreeColumn[MONSTAT_WAITTIME_COL_NUM];
		
		colTitle[MONSTAT_WAITTIME_COL_CALLER_NUM] = UIMessages._MONITOR_CALLER;
		colWidth[MONSTAT_WAITTIME_COL_CALLER_NUM] = MONSTAT_WAITTIME_COL_CALLER_DEFW;
		colTitle[MONSTAT_WAITTIME_COL_TOTAL_TIME_NUM] = UIMessages._TOTAL_WAITING_TIME;
		colWidth[MONSTAT_WAITTIME_COL_TOTAL_TIME_NUM] = MONSTAT_WAITTIME_COL_TOTAL_TIME_DEFW;
		colTitle[MONSTAT_WAITTIME_COL_COUNT_NUM] = UIMessages._WAITING_CONUT;
		colWidth[MONSTAT_WAITTIME_COL_COUNT_NUM] = MONSTAT_WAITTIME_COL_COUNT_DEFW;
		colTitle[MONSTAT_WAITTIME_COL_STAT_NUM] = UIMessages._MAX_AVG_MIN_TIME;
		colWidth[MONSTAT_WAITTIME_COL_STAT_NUM] = MONSTAT_WAITTIME_COL_STAT_DEFW;
		colTitle[MONSTAT_WAITTIME_COL_OBJECT_NUM_NUM] = UIMessages._OBJECT_NUMBER;
		colWidth[MONSTAT_WAITTIME_COL_OBJECT_NUM_NUM] = MONSTAT_WAITTIME_COL_OBJECT_NUM_DEFW;
		colTitle[MONSTAT_WAITTIME_COL_THREAD_NUM_NUM] = UIMessages._THREAD_NUMBER;
		colWidth[MONSTAT_WAITTIME_COL_THREAD_NUM_NUM] = MONSTAT_WAITTIME_COL_THREAD_NUM_DEFW;
		
		for (int i = 0; i < MONSTAT_WAITTIME_COL_NUM; i++) {
			columns[i] = new TreeColumn(tree, SWT.NULL | SWT.NO_BACKGROUND | SWT.LEFT);
			columns[i].setResizable(true);
			columns[i].setText(colTitle[i]);
			columns[i].setWidth(colWidth[i]);
			columns[i].addSelectionListener(getColumnSelectionListener(i));
		}
		
		_sorter.setColumns(columns);
	}

	SelectionListener getColumnSelectionListener(final int columnIndex) {
		return new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				_sorter.changeColumnSelection(columnIndex);
				_viewer.refresh();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		};
	}
	
	private IBaseLabelProvider getTableLabelProvider() {
		return this;
	}

	private IContentProvider getContentProvider() {
		return new MonitorWaitTimeStatisticContentProvider();
	}

	public Composite getViewContainer() {
		return _viewContainer;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	public void widgetSelected(SelectionEvent e) {
	}

	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		if (!(element instanceof MonitorCallDetails)) {
			// TODO add assert
			return null;
		}
		MonitorCallDetails monCallDetails = (MonitorCallDetails)element;		
		
		switch (columnIndex) {
		case MONSTAT_WAITTIME_COL_CALLER_NUM:
			return monCallDetails.getCallTitle();
		case MONSTAT_WAITTIME_COL_TOTAL_TIME_NUM:
			return Utils.formatTime(monCallDetails.getWaitingTime());
		case MONSTAT_WAITTIME_COL_COUNT_NUM:
			return new Integer(monCallDetails.getWaitingCount()).toString();
		case MONSTAT_WAITTIME_COL_STAT_NUM:
			return Utils.formatTime(monCallDetails.getMaxWaitingTime()) + " / " + 
				Utils.formatTime(monCallDetails.getAvgWaitingTime()) + " / " +
				Utils.formatTime(monCallDetails.getMinWaitingTime());
		case MONSTAT_WAITTIME_COL_OBJECT_NUM_NUM:
			return new Integer(monCallDetails.getWaitingObjectsCount()).toString();
		case MONSTAT_WAITTIME_COL_THREAD_NUM_NUM:
			return new Integer(monCallDetails.getWaitingThreadsCount()).toString();
		default:
			break;
		}
		return null;		
		
	}	
		
	class MonitorWaitingStatisticsSorter extends ViewerSorter {

		private int sortedIdx = -1;
		private boolean ascOrder = true;
		//private TreeColumn columns[] = null;
		
		void changeColumnSelection(int idx) {
			// column isn't sortable 
			if (MONSTAT_WAITTIME_COL_STAT_NUM == idx)
				return;
			
			if (sortedIdx == idx) {
				ascOrder = !ascOrder;
			}
			else {
				ascOrder = true;
			} 
			sortedIdx = idx;
		}
		
		void setColumns(TreeColumn columns[]) {
			//this.columns = columns;
		}
		
		public int compare(Viewer viewer, Object e1, Object e2) {
			if (!(e1 instanceof MonitorCallDetails) ||
				!(e2 instanceof MonitorCallDetails)) {
				return 0;
			}
			
			MonitorCallDetails cd1 = (MonitorCallDetails)e1;
			MonitorCallDetails cd2 = (MonitorCallDetails)e2;
			int result = 0; 
			
			switch (sortedIdx) {
			case MONSTAT_WAITTIME_COL_CALLER_NUM:
				result = cd1.getCallTitle().compareTo(cd2.getCallTitle());
				break;
			case MONSTAT_WAITTIME_COL_COUNT_NUM:
				result = cd1.getWaitingCount() - cd2.getWaitingCount();
				break;
			case MONSTAT_WAITTIME_COL_TOTAL_TIME_NUM:
				result = new Double(cd1.getWaitingTime())
					.compareTo(new Double (cd2.getWaitingTime()));
				break;
			case MONSTAT_WAITTIME_COL_OBJECT_NUM_NUM:
				result = cd1.getWaitingObjectsCount() - cd2.getWaitingObjectsCount();
				break;
			case MONSTAT_WAITTIME_COL_THREAD_NUM_NUM:
				result = cd1.getWaitingThreadsCount() - cd2.getWaitingThreadsCount();
				break;
			default:
				break;		
			}
			
			return ascOrder ? result : -result;
		}
		
		public boolean isSorterProperty(Object element, String property) {
			 return true;
		}
		
	}	
}

class MonitorWaitTimeStatisticContentProvider implements ITreeContentProvider {
	
	Object[] calls;
	
	public Object[] getChildren(Object parentElement) {
		return null;
	}

	public Object getParent(Object element) {
		return null;
	}

	public boolean hasChildren(Object element) {
		return false;
	}

	public Object[] getElements(Object inputElement) {
		return calls;
	}

	public void dispose() {
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (newInput instanceof Object[]) {
			calls = (Object[])newInput;
		}
	}
	
}
