/**********************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: MonitorStatisticController.java,v 1.1 2008/03/12 16:54:03 aalexeev Exp $
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Alexander  N. Alexeev, Intel - Initial API and implementation
 **********************************************************************/  

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.HashMap;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.forms.widgets.Form;

public class MonitorStatisticController {

	private EObject modelRoot;
	
	StructuredViewer _threadsViewer;
	StructuredViewer _classesViewer;
	StructuredViewer _blockTimeViewer;
	StructuredViewer _waitTimeViewer;
	Form             _classNameLable;
	
	HashMap _threads = new HashMap();
	
	public void setMOFObject(EObject object) {
		modelRoot = object;
		initialize();
	}

	public void setThreadsViewer(StructuredViewer _viewer) {
		_threadsViewer = _viewer;
	}

	public void setClassesTimeViewer(StructuredViewer _viewer) {
		_classesViewer = _viewer;
	}
	
	public void setClassLabel(Form _form) {
		_classNameLable = _form;
	}
	
	public void setBlockTimeViewer(StructuredViewer _viewer) {
		_blockTimeViewer = _viewer;
	}

	public void setWaitTimeViewer(StructuredViewer _viewer) {
		_waitTimeViewer = _viewer;
	}
	
	public void update() {
		//recalculate();
		_threadsViewer.setInput(_threads.values().toArray());
	}

	public void setSelectedThreads(MonitorThreadDetails[] threads) {
		_classNameLable.setText(UIMessages._MONITOR_CLASS_NAME); 
		_classesViewer.setInput(getMonitorClasses(threads));
		_blockTimeViewer.setInput(null);
		_waitTimeViewer.setInput(null);
	}
	
	private Object[] getMonitorClasses(MonitorThreadDetails[] threads) {
		return mergeClassDetails(threads);
	}

	private Object[] mergeClassDetails(MonitorThreadDetails[] threads){
		if (threads.length == 1) {
			return threads[0].getClassMap().values().toArray();
		}
		
		// TODO: VERY ineffective implementation, should be improved!!!  
		HashMap classMap = new HashMap();
		
		for (int t = 0; t < threads.length; t++) {
			TRCThread thread = threads[t].getThread();
			EList events = thread.getThreadEvents();
			int count = events.size();
			if (count > 0) {
				TRCThreadEvent event = (TRCThreadEvent)events.get(0);
				for (int i = 1; i < count; i++){
					TRCThreadEvent next = (TRCThreadEvent)events.get(i);
					double timeSpan = Math.max(next.getTime() - event.getTime(), 0);
					
					
					TRCObject monObject = null;
					MonitorClassDetails classDetails = null;

					if(event instanceof TRCThreadWaitingForObjectEvent) {
						monObject = ((TRCThreadWaitingForObjectEvent)event).getObjectWaitingFor();
					} else if(event instanceof TRCThreadWaitingForLockEvent) {
						monObject = ((TRCThreadWaitingForLockEvent)event).getLockedObject();
					}
					
					if (monObject != null) {
						TRCClass monObjClass =  PerftraceUtil.getClass(monObject);
						if (!classMap.containsKey(monObjClass)) {
							classDetails = new MonitorClassDetails(monObjClass);
							classMap.put(monObjClass, classDetails);
						} 
						else {
							classDetails = (MonitorClassDetails)classMap.get(monObjClass);
						}
					}
					
					if (null != classDetails) {
						classDetails.updateMonitorsData(event, timeSpan);
					}
					
					event = next;
				}
			}
		}
		
		return classMap.values().toArray();
	}

	
	public void setSelectedClass(Object classDesc) {
		_classNameLable.setText(UIMessages._MONITOR_CLASS_NAME + " "
				+ ((MonitorClassDetails)classDesc).getClassObj().getName());
		_blockTimeViewer.setInput(getBlockObjects(classDesc));
		_waitTimeViewer.setInput(getWaitObjects(classDesc));
	}

	private Object[] getWaitObjects(Object classDesc) {
		if (classDesc instanceof MonitorClassDetails) {
			return ((MonitorClassDetails)classDesc).getWaitCalls();
		}
		return null;
	}

	private Object[] getBlockObjects(Object classDesc) {
		if (classDesc instanceof MonitorClassDetails) {
			return ((MonitorClassDetails)classDesc).getBlockCalls();
		}
		return null;
	}
	
	private void initialize() {
		Object allThreads[] = PerftraceUtil.getAllThreads(modelRoot, false);
		for (int i = 0; i < allThreads.length; i++) {
			_threads.put(allThreads[i], new MonitorThreadDetails((TRCThread)allThreads[i]));
		}
	}	

//	private void recalculate() {
//		Object allThreads[] = PerftraceUtil.getAllThreads(modelRoot, false);
//		for (int i = 0; i < allThreads.length; i++) {
//			MonStatThreadDetails threadDetails = null;
//			if (!_threads.containsKey(allThreads[i])) {
//				threadDetails = new MonStatThreadDetails((TRCThread)allThreads[i]);
//				_threads.put(allThreads[i], threadDetails);
//			} else {
//				threadDetails = (MonStatThreadDetails)_threads.get(allThreads[i]);
//			}
//			threadDetails.recalculate();
//		}
//	}	

}
