/**********************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: MonitorStatisticView.java,v 1.1 2008/03/12 16:54:03 aalexeev Exp $
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Alexander  N. Alexeev, Intel - Initial API and implementation
 **********************************************************************/  

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Section;

public class MonitorStatisticView  extends BaseProfilerView {
	
	private final static String TABLE_SECTION_THREAD_TITLE = UIMessages._MONITOR_THREADS_TAB;
	private final static String TABLE_SECTION_MON_CLASSES_TITLE = UIMessages._MONITOR_CLASSES_TAB;
	private final static String TABLE_SECTION_MON_BLOCKED_TITLE = UIMessages._MONITOR_BLOCKED_TAB;
	private final static String TABLE_SECTION_MON_WAITING_TITLE = UIMessages._MONITOR_WAITING_TAB;
	
	private HyadesFormToolkit _toolkit;
	private MonitorThreadStatistics _threadsStatistics;	
	private MonitorClassStatistics _monitorsStatistics;	
	private MonitorClassBlockedStatistics _classBlockTimeStatistics;
	private MonitorClassWaitingStatistics _classWaitTimeStatistics;
	private Form _form;
	private MonitorStatisticController monViewCtrl;
	
	public MonitorStatisticView(Composite parent, TraceViewerPage page) {
		super(parent, page);
	}

	protected Control createDataViewer(Composite parent) {
		_toolkit = new HyadesFormToolkit(parent.getDisplay());
		monViewCtrl = new MonitorStatisticController();
		monViewCtrl.setMOFObject(_page.getMOFObject());
		Composite monitorComposite = _toolkit.createComposite(parent);
		monitorComposite.setLayout(new FillLayout(SWT.VERTICAL));
		
		Composite sourceComposite = _toolkit.createComposite(monitorComposite);
		sourceComposite.setLayout(new FillLayout(SWT.VERTICAL));
		createThreadsSection(sourceComposite);
		createMonitorsSection(sourceComposite);
		
		_form = _toolkit.createForm(monitorComposite);
		_form.setText(UIMessages._MONITOR_CLASS_NAME);
		_form.getBody().setLayout(new FillLayout(SWT.VERTICAL));
		monViewCtrl.setClassLabel(_form);

		createClassBlockSection(_form.getBody());
		createClassWaitSection(_form.getBody());
		return monitorComposite;
	}

	protected String getViewTypeStr() {
		return "viewoption.monitors";
	}

	protected void update() {
		monViewCtrl.update();
	}

	private void createThreadsSection(Composite parent) {
		Section section = _toolkit.createSection(parent, Section.TITLE_BAR);
		section.setText(TABLE_SECTION_THREAD_TITLE); 
		section.marginWidth = 3;
		section.marginHeight = 3;
        section.setLayout(new GridLayout());	
        _threadsStatistics = new MonitorThreadStatistics (section, monViewCtrl);
    	section.setClient(_threadsStatistics.getViewContainer());
	}
	
	private void createMonitorsSection(Composite parent) {
		Section section = _toolkit.createSection(parent, Section.TITLE_BAR);
		section.setText(TABLE_SECTION_MON_CLASSES_TITLE); 
		section.marginWidth = 3;
		section.marginHeight = 3;
    	section.setLayout(new GridLayout());
		_monitorsStatistics = new MonitorClassStatistics (section, monViewCtrl);
    	section.setClient(_monitorsStatistics.getViewContainer());
	}
	
	private void createClassBlockSection(Composite parent) {
		Section section = _toolkit.createSection(parent, Section.TITLE_BAR);
		section.setText(TABLE_SECTION_MON_BLOCKED_TITLE); 
		section.marginWidth = 3;
		section.marginHeight = 3;
        section.setLayout(new GridLayout());
		_classBlockTimeStatistics = new MonitorClassBlockedStatistics (section, monViewCtrl);
    	section.setClient(_classBlockTimeStatistics.getViewContainer());
	}
	
	private void createClassWaitSection(Composite parent) {
		Section section = _toolkit.createSection(parent, Section.TITLE_BAR);
		section.setText(TABLE_SECTION_MON_WAITING_TITLE); 
		section.marginWidth = 3;
		section.marginHeight = 3;
        section.setLayout(new GridLayout());
		_classWaitTimeStatistics = new MonitorClassWaitingStatistics (section, monViewCtrl);
    	section.setClient(_classWaitTimeStatistics.getViewContainer());	
	}	
	
	
}
