/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: OpenCallStackViewAction.java,v 1.5 2007/04/20 13:06:48 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.tptp.trace.jvmti.internal.client.TITracePlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OpenCallStackViewAction extends OpenTraceViewActionBase {

	static final String VIEW_ID = "org.eclipse.tptp.trace.jvmti.internal.client.views.CallStackViewer";//$NON-NLS-1$

	public OpenCallStackViewAction() {
		super("");
		setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(
				TITracePlugin.PLUGIN_ID,
				"icons/full/cview16/call_stack_view.gif"));//$NON-NLS-1$
		setText(UIMessages._ShowCallStack);
		setDescription(UIMessages._ShowCallStack);
		setToolTipText(UIMessages._ShowCallStack);
	}

	public String getViewID() {
		return VIEW_ID;
	}

	public String getErrorMsg() {
		return UIMessages.CANNOT_OPEN_CALL_STACK;
	}
}
