/*****************************************************************************
 * Copyright (c) 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: OpenTraceViewActionBase.java,v 1.7 2009/04/17 15:37:51 ewchan Exp $
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.OpenTraceViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class OpenTraceViewActionBase extends OpenTraceViewAction {

	public OpenTraceViewActionBase() {
		super("");
	}

	public OpenTraceViewActionBase(String label) {
		super(label);
	}

	public OpenTraceViewActionBase(String label, ImageDescriptor image) {
		super(label, image);
	}

	boolean acceptAgentName(String name) {
		return name.equals("org.eclipse.tptp.jvmti");
	}

	boolean canDisplayObject(EObject mofObject, boolean showError) {
		boolean ret = true;
		IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench()
			.getActiveWorkbenchWindow();
		if (mofObject == null) {
			if (showError) {
				String msg = UIMessages.EMPTY_PROFILE_SELECTION;
				Status err = new Status(Status.WARNING,
						ResourcesPlugin.PI_RESOURCES, msg);
				ErrorDialog.openError(window.getShell(), msg, "", err);
			}
			ret = false;
		} else {
			String name = Utils.getAgentName(mofObject);
			ret = acceptAgentName(name);
			if (!ret && showError) {
				String msg = UIMessages.DATA_NOT_SUPPORTED;
				String title = UIMessages.TRC_MSGT; 
				String msgMain = UIMessages.ER_MSG;
				Status err = new Status(Status.WARNING,
						ResourcesPlugin.PI_RESOURCES, msg);
				ErrorDialog.openError(window.getShell(), title, msgMain, err);
			}
			
		}
		return ret;
	}

	public abstract String getErrorMsg();

	void openView(boolean showError) {
		IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench()
				.getActiveWorkbenchWindow();

		// Check profiling type
		EObject mofObject = getMofObject();
		if (!canDisplayObject(mofObject, showError))
			return;

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			IViewPart view;
			
			EObject objectToView = getObjectToView(mofObject);
			view = persp.showView(getViewID());
			
			if (view != null && view instanceof TraceViewer) {
				((TraceViewer) view).addViewPage(objectToView, true);
			}
		} catch (Exception e) {
			if (showError) {
				String msg = getErrorMsg();
				Status err = new Status(Status.WARNING,
						ResourcesPlugin.PI_RESOURCES,
						IResourceStatus.INTERNAL_ERROR, e.toString(), null);
				ErrorDialog.openError(window.getShell(), msg, "", err);
			}
			e.printStackTrace();
		}
	}

	public void run() {
		openView(true);
	}

	public void run(IAction action) {
		run();
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
		EObject mofObject = getMofObject();
		action.setEnabled(canDisplayObject(mofObject, false));
	}
	 
	public EObject getObjectToView(EObject selObject) {
		return TraceViewer.getObjectToView_(selObject);
	}
}
