/********************************************************************** 
 * Copyright (c) 2007, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: StatisticViewColumnInfo.java,v 1.3 2009/08/11 21:15:33 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;

/**
 * This class was ported from hyades project for JVMTI trace client.
 */
public class StatisticViewColumnInfo {

	private boolean _isSortColumn = false;
	private boolean _isDeltaColumn = false;
	private ColumnData _columnData;

	public ColumnData getColumnData() {
		return _columnData;
	}

	public boolean isSortColumn() {
		return _isSortColumn;
	}

	public boolean isDeltaColumn() {
		return _isDeltaColumn;
	}

	public void setSortColumn(boolean flag) {
		_isSortColumn = flag;
	}

	public void setDeltaColumn(boolean flag) {
		_isDeltaColumn = flag;
	}

	static public StatisticViewColumnInfo getStatisticTableColumnInfo(TreeColumn col) {
		if (col.getData() != null && col.getData() instanceof StatisticViewColumnInfo) {
			return (StatisticViewColumnInfo) (col.getData());
		} else {
			return null;
		}
	}

	private StatisticViewColumnInfo(BaseStatisticView statisticView, ColumnData data) {
		TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), SWT.NULL | SWT.NO_BACKGROUND | data.getAlignment());
		treeColumn.setData(this);
		initializeTreeColumn(statisticView, treeColumn, data, true);
	}

	public StatisticViewColumnInfo(BaseStatisticView statisticView, ColumnData data, boolean deltaColumnsEnabled) {
		TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), SWT.NULL | SWT.NO_BACKGROUND | data.getAlignment());
		treeColumn.setData(this);
		initializeTreeColumn(statisticView, treeColumn, data, false);
		if (deltaColumnsEnabled && data.supportsDelta()) {
			new StatisticViewColumnInfo(statisticView, data);
		}
	}

	private void initializeTreeColumn(BaseStatisticView statisticView, TreeColumn treeColumn, ColumnData data, boolean isDeltaColumn) {
		_columnData = data;
		_isDeltaColumn = isDeltaColumn;
		treeColumn.setResizable(data.isResizable());
		if (isDeltaColumn) {
			treeColumn.setText(UIMessages._Delta + " : " + data.name());
		} else {
			treeColumn.setText(data.name());
		}
		treeColumn.setWidth(data.width());
		treeColumn.addSelectionListener(statisticView);
		//treeColumn.addControlListener(statisticView);
	}
}
