/*****************************************************************************
 * Copyright (c) 2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: TIColumnData.java,v 1.1 2007/02/27 18:37:33 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;

public class TIColumnData extends ColumnData {

	public TIColumnData(String key, int initialPos, int style, int alignment, int width) {
		super(key, initialPos, style, alignment, width);
	}

	public TIColumnData(ColumnData columnData) {
		super(columnData.key(), columnData.getInitalPos(), columnData.getStyle(), columnData.getAlignment(), columnData.width());
	}
	
	public String name() {
		IContextLabelFormatProvider clfp = TIContextProvider.instance().getContextLabelFormatProvider(key());
		if (clfp != null)
			return clfp.getDisplayStringFromElement(null, null, IContextLabelFormatProvider.MODE_COLUMN_HEADER);
		else
			return key();
	}

	static public ArrayList convertColumnData(ArrayList in) {
		ArrayList out = new ArrayList();
		Iterator it = in.iterator();
		while (it.hasNext()) {
			ColumnData cd = (ColumnData) it.next();
			out.add(new TIColumnData(cd));
		}
		return out;
	}
}
