/*****************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *    Alexander N. Alexeev, Intel - Add monitors statistics support
 *
 * $Id: ThreadAnalysisPage.java,v 1.2 2008/03/12 16:54:03 aalexeev Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadAnalysisPage extends TraceViewerPage {

	static public final int TAB_THREAD_STATISTIC = 0;
	static public final int TAB_MONITOR_STATISTIC = 1;
	static public final int TAB_THREAD_STATES = 2;
	static public final int TAB_NUM = 3;

	CTabFolder _tabFolder;
	BaseProfilerView _views[];

	public ThreadAnalysisPage(EObject mofObject, TraceViewer viewer) {
		super(mofObject, viewer);
	}

	public void refreshPage() {
		BaseProfilerView view = _views[_tabFolder.getSelectionIndex()];
		view.update();
		updateButtons();
	}

	public void selectionChanged() {
	}

	public void update(boolean newPage) {
		refreshPage();
	}

	public void createControl(Composite parent) {
		int selectedTab = Utils.loadIntOption("viewoption.threads.tab", 0, 0, TAB_NUM - 1);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = GridData.FILL;
		gd.grabExcessVerticalSpace = true;

		_tabFolder = new CTabFolder(parent, SWT.BOTTOM | SWT.FLAT);
		_tabFolder.setLayoutData(gd);
		_tabFolder.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent e) {
			}
			public void widgetSelected(SelectionEvent e) {
				BaseProfilerView view = _views[_tabFolder.getSelectionIndex()];
				view.update();
				view.updateModelSelection();
				updateButtons();
			}
		});

		_views = new BaseProfilerView[3];
		CTabItem tabItem;

		tabItem = new CTabItem(_tabFolder, SWT.NONE);
		tabItem.setText(UIMessages.THREAD_STATISTIC_TITLE);
		ThreadStatisticView view0 = new ThreadStatisticView(_tabFolder, this);
		_views[0] = view0;
		tabItem.setControl(_views[0].getControl());

		tabItem = new CTabItem(_tabFolder, SWT.NONE);
		tabItem.setText(UIMessages.MONITOR_STATISTIC_TITLE);
		MonitorStatisticView view1 = new MonitorStatisticView(_tabFolder, this);
		_views[1] = view1;
		tabItem.setControl(_views[1].getControl());		

		tabItem = new CTabItem(_tabFolder, SWT.NONE);
		tabItem.setText(UIMessages.THREAD_STATES_TITLE);
		ThreadStatesView view2 = new ThreadStatesView(_tabFolder, this);
		_views[2] = view2;
		tabItem.setControl(_views[2].getControl());
		
		_tabFolder.setSelection(selectedTab);
		setContextMenu(view0.getTree(), view0.getTreeViewer());
	}

	public void dispose() {
		int selectedTab = _tabFolder.getSelectionIndex();
		Utils.saveIntOption("viewoption.threads.tab", selectedTab);
		for (int i = 0; i < _views.length; i++)
			_views[i].dispose();
		super.dispose();
	}

	public Control getControl() {
		return _tabFolder;
	}

	public void setFocus() {
		_views[_tabFolder.getSelectionIndex()].getControl().setFocus();
	}

	public int getViewTab() {
		return _tabFolder.getSelectionIndex();
	}

	public void showViewTab(int tab) {
		if (TAB_THREAD_STATISTIC != tab && TAB_THREAD_STATISTIC != tab)
			return;
		_tabFolder.setSelection(tab);
		updateButtons();
	}

	public void updateButtons() {
		if (_viewer instanceof ThreadAnalysisViewer) {
			((ThreadAnalysisViewer)_viewer).updateButtons();
		}
	}

	public BaseProfilerView getCurrentView() {
		BaseProfilerView view = _views[_tabFolder.getSelectionIndex()];
		return view;
	}

	public boolean isEmpty() {
		return false;//PerftraceUtil.getTotalSize(getMOFObject()) <= 0;
	}
	
	public void fillContextMenu(IMenuManager menu) {
		BaseProfilerView view = _views[_tabFolder.getSelectionIndex()];
		view.menuAboutToShow(menu);
	}
}
