/*****************************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Ruslan A. Scherbakov, Intel - Initial API and implementation
 *
 * $Id: ThreadAnalysisViewer.java,v 1.12 2008/06/03 16:53:41 aalexeev Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.tptp.trace.jvmti.internal.client.TITracePlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * Thread analysis viewer class.
 */
public class ThreadAnalysisViewer extends TraceViewer implements ICallStackProvider {
	public static final String VIEW_ID = "org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadAnalysisViewer";
	public static final String RUNTIME_ID = "RUNTIME_ID";
	
	protected Action _selectNextEvent;
	protected Action _selectPrevEvent;
	protected Action _selectNextThread;
	protected Action _selectPrevThread;
	protected Action _groupThreads;
	protected Action _filterThreads;
	protected Action drawThreadInteraction;
	protected Action _resetTimescale;
	protected Action _chooseColumns;
	protected Action _sortByColumn;
	protected Action _openCallStackView;
	protected Action showLegend;
	protected Action _zoomIn;
	protected Action _zoomOut;
	protected ContextSelectionMenuListener _contextSelectionMenuListener;
	protected int _viewTab = -1;

	/** Returns trace page implementation. */
	public TraceViewerPage createPage(EObject mofObject) {
		return new ThreadAnalysisPage(mofObject, this);
	}

	/** Returns viewer title. */
	public String getViewTitle() {
		return UIMessages.THREAD_ANALYSIS_TITLE;
	}

	/** Returns the default page message. */
	public String getDefaultPageMessage() {
		return UIMessages.NO_THREAD_STATS;
	}

	/** Set the focus to current page. */
	public void setFocus() {
		if (getCurrentPage() != null)
			getCurrentPage().setFocus();
	}

	/** Updates action buttons. */
	public void updateButtons() {
		refillActions();
	}

	public Object[] getViewerControls() {
		BaseProfilerView view = getCurrentView();
		if (view instanceof ThreadStatisticView) {
			return new Object[] { ((ThreadStatisticView)view).getTree() };
		}
		return null;
	}

	public EObject getObjectToView(EObject selObject) {
		return getObjectToView_(selObject);
	}

	public void makeActions() {
		if (isInitializedMenu())
			return;
		super.makeActions();
		initializedMenu(true);
		createActions();
		refillActions();
	}

	/** Updates action sets in toolbar and menu in view site. */
	public void refillActions() {
		if (getViewTab() == _viewTab)
			return;
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
		bars.updateActionBars();
		_viewTab = getViewTab();
	}

	/** Populates actions in view site menu. */
	private void fillLocalPullDown(IMenuManager menu) {
		menu.removeAll();
		int viewTab = getViewTab();
		boolean stats = viewTab == ThreadAnalysisPage.TAB_THREAD_STATISTIC;
		if (stats) {
			menu.add(_chooseColumns);
			menu.add(_sortByColumn);
		}
	}

	/** Populates actions in view site toolbar. */
	private void fillLocalToolBar(IToolBarManager toolbar) {
		toolbar.removeAll();
		int viewTab = getViewTab();
		boolean stats = viewTab == ThreadAnalysisPage.TAB_THREAD_STATISTIC;
		boolean states = viewTab == ThreadAnalysisPage.TAB_THREAD_STATES;
		
		if (states) {
			toolbar.add(showLegend);
			toolbar.add(_openCallStackView);
			toolbar.add(_resetTimescale);
			toolbar.add(_zoomIn);
			toolbar.add(_zoomOut);
			toolbar.add(_selectPrevEvent);
			toolbar.add(_selectNextEvent);
			toolbar.add(_selectPrevThread);
			toolbar.add(_selectNextThread);
			toolbar.add(_groupThreads);
			toolbar.add(_filterThreads);
			toolbar.add(drawThreadInteraction);
		}
		else if (stats) {
			toolbar.add(_openCallStackView);
			toolbar.add(_printColumns);
		}
	}

	/** Creates all actions. */
	private void createActions() {
		if (_chooseColumns != null)
			return;

		String strChooseColumns = UIMessages._ChooseColumns;
		_chooseColumns = new Action(strChooseColumns) {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatisticView) {
					((ThreadStatisticView) view).getChooseColumnsAction().run();
				}
			}
		};
		_chooseColumns.setText(strChooseColumns);
		TracePluginImages.setImageDescriptors(_chooseColumns,
				TracePluginImages.T_LCL, TracePluginImages.IMG_CHOOSECOLUMNS);
		_chooseColumns.setDescription(strChooseColumns);
		_chooseColumns.setToolTipText(strChooseColumns);

		String strSortByColumn = UIMessages._SortByColumn;
		_sortByColumn = new Action(strSortByColumn) {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatisticView) {
					((ThreadStatisticView) view).getSortByColumnAction().run();
				}
			}
		};
		_sortByColumn.setText(strSortByColumn);
		TracePluginImages.setImageDescriptors(_sortByColumn,
				TracePluginImages.T_LCL, TracePluginImages.IMG_SORTCOLUMNS);
		_sortByColumn.setDescription(strSortByColumn);
		_sortByColumn.setToolTipText(strSortByColumn);

		_openCallStackView = new OpenCallStackViewAction();

		_resetTimescale = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).resetStartFinishTime();
				}
			}
		};
		_resetTimescale.setText(UIMessages._RESET_TIMESCALE);
		_resetTimescale.setToolTipText(UIMessages._RESET_TIMESCALE_TTIP);
		_resetTimescale.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.hyades.trace.views"
				, "icons/full/ctool16/home_nav.gif"));

		_zoomIn = new Action () {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).zoomIn();
				}
			}
		};
		_zoomIn.setText(UIMessages._ZOOM_IN);
		_zoomIn.setToolTipText(UIMessages._ZOOM_IN_TTIP);
		_zoomIn.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.hyades.trace.views",
				"icons/full/clcl16/zoomin_nav.gif"));

		_zoomOut = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView();
					if (view instanceof ThreadStatesView) {
						((ThreadStatesView) view).zoomOut();
					}
				}
			};
		_zoomOut.setText(UIMessages._ZOOM_OUT);
		_zoomOut.setToolTipText(UIMessages._ZOOM_OUT_TTIP);
		_zoomOut.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(
				"org.eclipse.hyades.trace.views",
				"icons/full/clcl16/zoomout_nav.gif"));
				
		_selectNextEvent = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).selectNextEvent();
				}
			}
		};
		_selectNextEvent.setText(UIMessages._NEXT_EVENT);
		_selectNextEvent.setToolTipText(UIMessages._NEXT_EVENT_TTIP);
		_selectNextEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/obj16/next_event.gif"));

		_selectPrevEvent = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).selectPrevEvent();
				}
			}
		};
		_selectPrevEvent.setText(UIMessages._PREV_EVENT);
		_selectPrevEvent.setToolTipText(UIMessages._PREV_EVENT_TTIP);
		_selectPrevEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/obj16/prev_event.gif"));

		_selectNextThread = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).selectNextThread();
				}
			}
		};
		_selectNextThread.setText(UIMessages._NEXT_THREAD);
		_selectNextThread.setToolTipText(UIMessages._NEXT_THREAD_TTIP);
		_selectNextThread.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/obj16/next_thread.gif"));

		_selectPrevThread = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).selectPrevThread();
				}
			}
		};
		_selectPrevThread.setText(UIMessages._PREV_THREAD);
		_selectPrevThread.setToolTipText(UIMessages._PREV_THREAD_TTIP);
		_selectPrevThread.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/obj16/prev_thread.gif"));

		_groupThreads = new Action("", Action.AS_CHECK_BOX) {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).groupThreads(isChecked());
				}
			}
		};
		_groupThreads.setChecked(true);		// show grouped threads
		_groupThreads.setText(UIMessages._GROUP_THREADS);
		_groupThreads.setToolTipText(UIMessages._GROUP_THREADS_TTIP);
		_groupThreads.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/etool16/group_threads.gif"));
		_groupThreads.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/dtool16/group_threads.gif"));

		_filterThreads = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).filterThreads();
				}
			}
		};
		_filterThreads.setText(UIMessages._FILTER_THREADS);
		_filterThreads.setToolTipText(UIMessages._FILTER_THREADS_TTIP);
		_filterThreads.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/obj16/filter_threads.gif"));

		drawThreadInteraction = new Action(UIMessages._DRAW_THREAD_INTERACTION, IAction.AS_DROP_DOWN_MENU) {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).toggleThreadsInteractionDrawing();
				}
			}
		};
		drawThreadInteraction.setToolTipText(UIMessages._DRAW_THREAD_INTERACTION);
		drawThreadInteraction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(TITracePlugin.PLUGIN_ID
				, "icons/full/obj16/draw_interaction.gif"));
		drawThreadInteraction.setMenuCreator(new IMenuCreator() {
			public void dispose() {}

			public Menu getMenu(Control parent) {
				Menu menu = new Menu(parent);

				ThreadStatesView tsv;
				BaseProfilerView v = getCurrentView();
				if (v != null && v instanceof ThreadStatesView)
					tsv = (ThreadStatesView) v;
				else
					tsv = null;
				
				final MenuItem mjoin = new MenuItem(menu, SWT.CHECK);
				mjoin.setText(UIMessages._JOIN_TERMINATE);
				if (tsv != null)
					mjoin.setSelection(tsv.getThreadJoinDrawing());
				
				mjoin.addSelectionListener(new SelectionListener() {
					public void widgetDefaultSelected(SelectionEvent e) {}
					public void widgetSelected(SelectionEvent e) {
						BaseProfilerView view = getCurrentView(); 
						if (view instanceof ThreadStatesView) {
							((ThreadStatesView) view).setThreadJoinDrawing(mjoin.getSelection());
						}
					}
				});
			
				final MenuItem mwait = new MenuItem(menu, SWT.CHECK);
				mwait.setText(UIMessages._WAIT_NOTIFY);
				if (tsv != null)
					mwait.setSelection(tsv.getThreadWaitDrawing());
				
				mwait.addSelectionListener(new SelectionListener() {
					public void widgetDefaultSelected(SelectionEvent e) {}
					public void widgetSelected(SelectionEvent e) {
						BaseProfilerView view = getCurrentView(); 
						if (view instanceof ThreadStatesView) {
							((ThreadStatesView) view).setThreadWaitDrawing(mwait.getSelection());
						}
					}
				});
				
				final MenuItem mrel = new MenuItem(menu, SWT.CHECK);
				mrel.setText(UIMessages._RELEASE_ACQUIRE);
				if (tsv != null)
					mrel.setSelection(tsv.getThreadReleaseDrawing());
				
				mrel.addSelectionListener(new SelectionListener() {
					public void widgetDefaultSelected(SelectionEvent e) {}
					public void widgetSelected(SelectionEvent e) {
						BaseProfilerView view = getCurrentView(); 
						if (view instanceof ThreadStatesView) {
							((ThreadStatesView) view).setThreadReleaseDrawing(mrel.getSelection());
						}
					}
				});
				
				return menu;
			}

			public Menu getMenu(Menu parent) {
				return null;
			}
		});
		
		showLegend = new Action() {
			public void run() {
				BaseProfilerView view = getCurrentView(); 
				if (view instanceof ThreadStatesView) {
					((ThreadStatesView) view).showLegend();
				}
			}
		};
		showLegend.setText(UIMessages._LEGEND);
		showLegend.setToolTipText(UIMessages._LEGEND_HINT);
	}

	public Object getCallStack() {
		BaseProfilerView view = getCurrentView();
		return view != null ? view.getSelection() : null;
	}

	public BaseProfilerView getCurrentView() {
		if (!(getCurrentPage() instanceof ThreadAnalysisPage))
			return null;
		ThreadAnalysisPage page = (ThreadAnalysisPage) getCurrentPage();
		return page.getCurrentView();
	}

	public int getViewTab() {
		if (!(getCurrentPage() instanceof ThreadAnalysisPage))
			return -1;
		ThreadAnalysisPage page = (ThreadAnalysisPage) getCurrentPage();
		return page.getViewTab();
	}

	public void showPage(IPage page) {
		super.showPage(page);
		updateButtons();
	}
	
	public String getViewID() {
		return VIEW_ID;
	}

	public void init(IViewSite site, IMemento memento) throws PartInitException {
		super.init(site, memento);
		if (memento == null) return;

		final String rid = memento.getString(RUNTIME_ID);
		if (rid == null) return;

		loadingTrace();
		
		site.getShell().getDisplay().asyncExec(new Runnable() {
			public void run() {
				PDProjectExplorer.getFromActivePerspective();
				
				EObject obj = PDContentProvider.getAgent(rid);
				if (obj != null) 
					addViewPage(obj, true);
				else
					loadingTraceDone();
			}
		});
	}
	
	public void saveState (IMemento memento) {
		String rid = null;
		if (_mofObject != null && _mofObject instanceof TRCAgentProxy) {
			rid = ((TRCAgentProxy) _mofObject).getRuntimeId();
		}

		if (rid != null) {
			memento.putString(RUNTIME_ID, rid);
			super.saveState(memento);
		}
	}
}
