/*****************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: ThreadFilterDialog.java,v 1.2 2008/03/05 17:31:07 ewchan Exp $ 
 *****************************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ThreadFilterDialog extends TitleAreaDialog {
	private CheckboxTableViewer viewer;
	private Object[] threads;
	private boolean[] filter;
	
	public ThreadFilterDialog(Shell parentShell, Object[] threads, boolean[] filter) {
		super(parentShell);
		
		this.threads = threads;
		if (filter != null) 
			this.filter = (boolean[]) filter.clone();
	}

	public static boolean getThreadFilter(Shell parentShell, Object[] threads, boolean[] filter) {
		ThreadFilterDialog dlg = new ThreadFilterDialog(parentShell, threads, filter);
		if (dlg.open() != Window.OK) return false;
		
		boolean f[] = dlg.getFilter();
		if (java.util.Arrays.equals(f, filter)) return false;
		for (int i=f.length-1; i>=0; i--) filter[i] = f[i];
		
		return true;
	}
	

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		
		viewer = CheckboxTableViewer.newCheckList(composite, SWT.BORDER | SWT.V_SCROLL);

		Table table = viewer.getTable();
		table.setLayoutData (new GridData (GridData.FILL_BOTH));
		table.setBackground(parent.getBackground());
		createColumns(table);
		
		viewer.setContentProvider(new ViewContentProvider());
		viewer.setComparator (new ThreadComparator());
		viewer.setLabelProvider(new ViewLabelProvider());
		viewer.setInput(new Object());
		
		viewer.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				Object o = event.getElement();
				for (int i=threads.length-1; i>=0; i--) {
					if (threads[i].equals(o))
					filter[i] = event.getChecked();
				}
			}
		});
		
		if (filter != null) {
			for (int i=0; i<filter.length; i++) 
				viewer.setChecked(threads[i], filter[i]);
		}
		
		setMessage(UIMessages._THREADS_FILTER_DESC);
		setTitle(UIMessages._THREADS_FILTER);
		setDialogHelpAvailable(false);
		setHelpAvailable(false);
		
		setTitleImage(org.eclipse.hyades.trace.internal.ui.PDPluginImages.DESC_IMG_UI_WZ_EDITPROFSET.createImage());

		return composite;
	}

	private void createColumns(Table table) {
		table.setHeaderVisible(true);

		String headers[] = {"", UIMessages._THREAD_ID, UIMessages._THREAD_NAME };
		int width[] = { 20, 80, 400 };

		for (int i=0; i<headers.length; i++) {
			TableColumn tc = new TableColumn(table, SWT.NONE, i);
			tc.setResizable(true);
			tc.setText(headers[i]);
			tc.setWidth(width[i]);
		}
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(UIMessages._EDIT_PROFILING_OPTIONS);
	}

	public boolean[] getFilter() {
		return filter;
	}
	
	class ViewContentProvider implements IStructuredContentProvider {
		public void dispose() {}
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		public Object[] getElements(Object input) { return threads;	}
	}

	class ViewLabelProvider extends LabelProvider implements ITableLabelProvider {
		public Image getImage(Object obj) {	return null; }
		public Image getColumnImage(Object element, int columnIndex) { return null;	}

		public String getColumnText(Object element, int columnIndex) {
			TRCThread t = (TRCThread) element;
			
			if (columnIndex == 1)
				return String.valueOf(t.getId());
			else if (columnIndex == 2)
				return t.getName();
			else
				return "";
		}
	}
	
	class ThreadComparator extends ViewerComparator {
		public int compare(Viewer viewer, Object e1, Object e2) {
			int id1 = ((TRCThread) e1).getId();
			int id2 = ((TRCThread) e2).getId();
			
			if (id1 == id2) return 0;
			
			return (id1 < id2) ? -1 : 1;
		}
	}
}
