/**********************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 **********************************************************************/

package org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextAttributes;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseMemoryStatisticView.AgeInfo;

public class AvgAgeLabelAdapter extends NumberLabelAdapter {

	Map _ageMap;
	
	public AvgAgeLabelAdapter(Map ageMap) {
		_ageMap = ageMap;
	}

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage) {
			return null;
		}
		if (element instanceof TRCClass) {
			AgeInfo age = (AgeInfo) _ageMap.get(element);
			double sum = age != null ? age.sumAges : 0;
			int count = age != null ? age.objCount : 0;
			if (count > 0)
				sum /= count;
			else
				sum = 0;
			return new Double(sum);
		}
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		return null;
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		if (eObj instanceof TRCPackage)
			return TIContextAttributes.PACKAGE_AVG_AGE;
		else if (eObj instanceof TRCClass)
			return TIContextAttributes.CLASS_AVG_AGE;
		else
			return null;
		// TODO call sites
	}			
}
